package carleton.swapbox;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.util.Iterator;
import sun.beanbox.*;

public class MappingRulesState extends SwapConfigState {
    
    private Label oldStatesLabel = new java.awt.Label();
	private Label newStatesLabel = new java.awt.Label();
	private List oldStatesList = new java.awt.List(4);
	private List newStatesList = new java.awt.List(4);
	private Button addButton = new java.awt.Button();
	private Label serLabel = new java.awt.Label();
	private Checkbox serYESRadioButton = new java.awt.Checkbox();
	private CheckboxGroup Group1 = new java.awt.CheckboxGroup();
	private Checkbox serNORadioButton = new java.awt.Checkbox();
	private String originalXMLString;
	
	public MappingRulesState(SwapConfigState scs) throws SwapException{
	    previousState = scs;
        scs.setNextState(this);
        
	    statePanel = new Panel();
	    statePanel.setLayout(null);
		statePanel.setBackground(java.awt.Color.lightGray);
		statePanel.setBounds(12,12,409,385);
		
		oldStatesLabel.setText("Available Old States");
		oldStatesLabel.setAlignment(java.awt.Label.CENTER);
		statePanel.add(oldStatesLabel);
		oldStatesLabel.setFont(new Font("Dialog", Font.BOLD, 12));
		oldStatesLabel.setBounds(60,96,120,24);
		
		newStatesLabel.setText("Available New States");
		newStatesLabel.setAlignment(java.awt.Label.CENTER);
		statePanel.add(newStatesLabel);
		newStatesLabel.setFont(new Font("Dialog", Font.BOLD, 12));
		newStatesLabel.setBounds(228,96,120,24);
		
		statePanel.add(oldStatesList);
		oldStatesList.setBounds(60,132,119,160);
		oldStatesList.setMultipleMode(false);
		oldStatesList.select(0);
		
		statePanel.add(newStatesList);
		newStatesList.setBounds(228,132,119,160);
		newStatesList.setMultipleMode(false);
		newStatesList.select(0);
		
		addButton.setLabel("Add");
		statePanel.add(addButton);
		addButton.setFont(new Font("Dialog", Font.BOLD, 14));
		addButton.setBounds(168,312,84,27);
		addButton.addActionListener(new AddButtonHandler());
		
		serLabel.setText("Java Serialization: ");
		statePanel.add(serLabel);
		serLabel.setFont(new Font("Dialog", Font.BOLD, 14));
		serLabel.setBounds(72,24,144,43);
		
		serYESRadioButton.setCheckboxGroup(Group1);
		serYESRadioButton.setLabel("YES");
		statePanel.add(serYESRadioButton);
		serYESRadioButton.setFont(new Font("Dialog", Font.BOLD, 12));
		serYESRadioButton.setBounds(228,24,60,40);
		serYESRadioButton.setState(false);
		
		serNORadioButton.setCheckboxGroup(Group1);
		serNORadioButton.setLabel("NO");
		statePanel.add(serNORadioButton);
		serNORadioButton.setFont(new Font("Dialog", Font.BOLD, 12));
		serNORadioButton.setBounds(288,24,60,40);
		serNORadioButton.setState(true);
		
		panelTitle = "Config Mapping Rules";
		
		Vector oldNames = SwapConfigGenerator.analyzeOldVars(editor.getOldWrapper().getBean());
		Vector newNames = SwapConfigGenerator.analyzeNewVars(editor.getNewWrapper().getBean());
		if (((SwapBox)BeanBoxFrame.getCurrentBeanBox()).getSmartMode()) {
		    Iterator ite = oldNames.iterator();
		    originalXMLString = "";
		    while(ite.hasNext()) {
		        Object o = ite.next();
		        if (newNames.contains(o)) {
		            ite.remove();
		            newNames.remove(o);
		            originalXMLString += "\n       <state newName=\"" + (String)o + "\" oldName=\"" 
		                               + (String)o + "\">" + "\n       </state>";
		        }
		    }
		}
		if (oldNames != null) {
		    for (int i = 0; i < oldNames.size(); i++) {
		        oldStatesList.add((String)oldNames.elementAt(i));
		    }
		}
		if (newNames != null) {
		    for (int i = 0; i < newNames.size(); i++) {
		        newStatesList.add((String)newNames.elementAt(i));
		    }
		}
		
		xmlString = "";
	}
	
	public String toString() {
	    return "This is an instance of MappingRulesState";
	}
	    
    
    public SwapConfigState handleForwardEvent() {
        if (nextState == null) {
            SwapConfigState scs = new InteractionState(this);
            return scs;
        } else {
            nextState.activate();
            return nextState;
        }
    }
    
    public SwapConfigState handleResetEvent() {
        // xmlString = "\n    <state_policy>";
        xmlString = "";
        serYESRadioButton.setState(false);
        serNORadioButton.setState(true);
        newStatesList.select(0);
        oldStatesList.select(0);
        return null;
    }
    
    public String getXMLString() {
        String temp = "\n    <state_policy>";
        if (serYESRadioButton.getState()) {
            temp += "\n       <Serialization>true</Serialization>";
        } else {
            temp += "\n       <Serialization>false</Serialization>";
        }
        temp += originalXMLString + xmlString + "\n    </state_policy>";
        return temp;
    }
    
    public void activate() {
        // xmlString = "\n    <state_policy>";
    }
        
    
    private class AddButtonHandler implements ActionListener {
	    public void actionPerformed (ActionEvent ae) {
	        if (serNORadioButton.getState()) {
	            String newState = newStatesList.getSelectedItem();
	            String oldState = oldStatesList.getSelectedItem();
	            xmlString += "\n       <state newName=\"" + newState + "\" oldName=\"" + oldState + "\">" 
	                       + "\n       </state>";
	        } else {
	            new ErrorDialog (editor, "No mapping rules needed when using Java Serialization");
	        }
	    }
	}
}