package carleton.swapbox;

import java.lang.reflect.*;
import java.util.*;
import org.w3c.dom.*; 
import sun.beanbox.*;

public class Option2SwapManager extends DefaultSwapManager {
    
    public Option2SwapManager(Document document){
        super(document);
    }
    
    public void handlePostProcess(Node node) throws SwapException {
        Element element = (Element)node;
        NodeList swapMethodNode = element.getElementsByTagName("swap_method");
        String swapMethodName = "";
               
        if (swapMethodNode.getLength() == 1 && swapMethodNode.item(0).getNodeType() == Node.ELEMENT_NODE) {
            NodeList swapMethodText = swapMethodNode.item(0).getChildNodes();
            if (swapMethodText.getLength() == 1 && swapMethodText.item(0).getNodeType() == Node.TEXT_NODE
                && swapMethodText.item(0).getNodeValue() != null) {
                    
                swapMethodName = swapMethodText.item(0).getNodeValue();
            }
        } else {
            unblockService(oldWrapper);
            cleanup(newWrapper);
            ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(true);
            throw new SwapException("SwapManager: Parsing swap_method failed");
           
        }     
        
        Method[] newMethods = newWrapper.getBean().getClass().getMethods();
        boolean found = false;
        if (!swapMethodName.equalsIgnoreCase("null")) {
            for (int i = 0; i < newMethods.length; i++) {
                if (newMethods[i].getName().equalsIgnoreCase(swapMethodName)) {
                    try {
                        Object args[] = {};
                        newMethods[i].invoke(newWrapper.getBean(), args);
                    } catch (Exception ex) {
                        unblockService(oldWrapper);
                        cleanup(newWrapper);
                        ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(true);
                        throw new SwapException("SwapManager: Invoke method at new Module failed" +
                                            "\n   " + ex.getMessage());
                    }
                    found = true;
                    break;
                }
            }
            if (!found) {
                throw new SwapException("SwapManager: There is no swapMethod() at the new S-Module");
            }
        }
        
        unblockService(newWrapper);
        BeanReport br = ac.getBeanReport(oldWrapper.getBean());
        Vector v = br.getOutgoingEvents();
        for (int i = 0; i < v.size(); i++) {
            SwapEventInfo sei = (SwapEventInfo)v.elementAt(i);
            ((SwapAdapter)sei.getAdapter()).setBlock(false);
        }
        v = br.getIncomingEvents();
        for (int i = 0; i < v.size(); i++) {
            SwapEventInfo sei = (SwapEventInfo)v.elementAt(i);
            ((SwapAdapter)sei.getAdapter()).setService(false);
        }
        ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(true);
	}
}