package carleton.swapbox;

import sun.beanbox.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.beans.*;
import java.beans.beancontext.*;
import java.lang.reflect.Method;


public class SwapBox extends BeanBox{
    
    public synchronized void updateMenuBar(MenuBar bar) {
        BeanBoxFrame frame = getFrame();
        /*MenuItem vOn = new MenuItem("On");
	    MenuItem vOff = new MenuItem("Off");
	    MenuItem sOn = new MenuItem("On");
	    MenuItem sOff = new MenuItem("Off");*/
                
        if (bar.getMenuCount() == 0) {
	    // Create the basic menus.  These are bean/beanbox independent.

	        Menu m = new Menu("File"); // menu 0
	        addMenuItem(frame, m, new MenuItem("Save..."));
	        addMenuItem(frame, m, new MenuItem("SerializeComponent..."));
	        addMenuItem(frame, m, new MenuItem("MakeApplet..."));
	        addMenuItem(frame, m, new MenuItem("Load..."));
	        addMenuItem(frame, m, new MenuItem("LoadJar..."));
	        addMenuItem(frame, m, new MenuItem("Print"));
	        addMenuItem(frame, m, new MenuItem("Clear"));
	        addMenuItem(frame, m, new MenuItem("Exit"));
	        bar.add(m);

	        m = new Menu("Edit"); // menu 1
	        addMenuItem(frame, m, new MenuItem("Cut"));
	        addMenuItem(frame, m, new MenuItem("Copy"));
	        pasteMenuItem = new MenuItem("Paste");
	        pasteMenuItem.setEnabled(false);
	        addMenuItem(frame, m, pasteMenuItem);
	        addMenuItem(frame, m, new MenuItem("Report..."));
	        bar.add(m);

	        m = new Menu("View"); // menu 2
	        bar.add(m);

	        m = new Menu("Services"); // menu 3 
	        addMenuItem(frame, m, new MenuItem("InfoBus Support..."));
	        addMenuItem(frame, m, new MenuItem("Hide Method Tracing"));
	        bar.add(m);
	    
    	    // Code for Hot-Swapping
	        // Add a brand new menu--Swap menu. The menu will be available when users
	        // click Swap submenu of Edit menu on.
	        m = new Menu("Swap");  // menu 4
	        //addMenuItem(frame, m, new MenuItem("Verbose"));
	        addMenuItem(frame, m, new MenuItem("Event Info"));
	        addMenuItem(frame, m, new MenuItem("Swap"));
	        //addMenuItem(frame, m, new MenuItem("Swap with State"));
	        addMenuItem(frame, m, new MenuItem("Config Swap"));
	        
	        bar.add(m);

	        m = new Menu("Help"); // menu 5 (was menu 4! (or was it the help menu...))
	        addMenuItem(frame, m, new MenuItem("About..."));
	        addMenuItem(frame, m, new MenuItem("Documentation..."));
	        bar.setHelpMenu(m);
	    }
	    
	    Menu swapMenu = bar.getMenu(SWAP_MENUID);
	    for (int i = 0; i < swapMenu.getItemCount(); ++i) {
	        String label = swapMenu.getItem(i).getLabel();
	        if (label.equals("Verbose") || label.equals("Smart Mode")) {
	            swapMenu.remove(i);
	            i--;
	        }
	    }
	    Menu vMenu = new Menu("Verbose");
	    MenuItem vOn = new MenuItem("On");
	    MenuItem vOff = new MenuItem("Off");
	    addMenuItem(frame, vMenu, vOn);
	    addMenuItem(frame, vMenu, vOff);
	    if (verbose) {
	        vOn.setEnabled(false);
	        vOff.setEnabled(true);
	    } else {
	        vOn.setEnabled(true);
	        vOff.setEnabled(false);
	    }
	    swapMenu.add(vMenu);
	        
	    Menu sMenu = new Menu("Smart Mode");
	    MenuItem sOn = new MenuItem("On");
	    MenuItem sOff = new MenuItem("Off");
	    addMenuItem(frame, sMenu, sOn);
	    addMenuItem(frame, sMenu, sOff);
	    if (smartMode) {
	        sOn.setEnabled(false);
	        sOff.setEnabled(true);
	    } else {
	        sOn.setEnabled(true);
	        sOff.setEnabled(false);
	    }
	    swapMenu.add(sMenu);
	
    	Menu editMenu = bar.getMenu(EDIT_MENUID);

	    // Remove any bean-specific menu items from the edit menu.
	    for (int i = 0; i < editMenu.getItemCount(); i++) {
	        String label = editMenu.getItem(i).getLabel();
	        if (label.equals("Customize...") || label.equals("Events") ||
    			label.equals("Bind property...") || label.equals("Swappable")) {
	    	    editMenu.remove(i);
		        i--;
	        }
	    }
	    customizerClass = null;
	    getFrame().setCustomizer(null);
	    eventMap = null;
	    methodMap = null;

    	resetViewMenu();

	    // Take a look at the current focus bean, and create appropriate
	    // menu items for its events, customizer, etc.

	    try {
	        Object bean = BeanBoxFrame.getCurrentBean();
	        BeanInfo bi = Introspector.getBeanInfo(bean.getClass());

    	    try {
	        	BeanDescriptor bd = bi.getBeanDescriptor();
	            customizerClass = bd.getCustomizerClass();
		        if (customizerClass != null) {
		            addMenuItem(frame, editMenu, new MenuItem("Customize..."));
		        }
	        } catch (Exception ex) {
		        error("Couldn't initialize customizer", ex);
	        }

	        java.beans.EventSetDescriptor esd[] = bi.getEventSetDescriptors();
	        boolean bindable = false;
	        if (esd.length > 0) {
	            Menu eventMenu = new Menu("Events");
	            //Menu swapEventMenu = new Menu("SwapEvents");
		        eventMap = new Hashtable();
		        methodMap = new Hashtable();
		        // We create a separate menu for each event listener interface,
		        // with a menu item for each event handler method.
	            for (int i = 0; i < esd.length; i++) {
		            String dname = esd[i].getDisplayName();
		            Menu methodMenu = new Menu(dname);
		            eventMap.put(methodMenu, esd[i]);
		            Method methods[] = esd[i].getListenerMethods();
		            for (int j = 0; j < methods.length; j++) {
			            String mname = methods[j].getName();
			            MenuItem mi = new MenuItem(mname);
			            addMenuItem(frame, methodMenu, mi);
			            methodMap.put(mi, methods[j]);
	    	        }
		            eventMenu.add(methodMenu);
		            if (esd[i].getName().equals("propertyChange")) {
			            bindable = true;
		            }
	            }
	            editMenu.add(eventMenu);
	            
	            if (eventsMenuEnable) {
	                eventMenu.setEnabled(true);
	            } else {
	                eventMenu.setEnabled(false);
	            }
	        }

	        if (bindable) {
		        addMenuItem(frame, editMenu, new MenuItem("Bind property..."));
	        }

	    } catch (IntrospectionException ex) {
	        error("Caught unexpected exception while building event menu", ex);
	    }
	    /**
	    * Code for Hot-Swapping
	    * This shows up the "Swap" submenu in Edit menu. It provides facility to 
	    * activate or deactivate swap mode
	    */
	    Menu swappableMenu = new Menu("Swappable");
	    MenuItem swapOn = new MenuItem("On");
	    MenuItem swapOff = new MenuItem("Off");
	    addMenuItem(frame, swappableMenu, swapOn);
	    addMenuItem(frame, swappableMenu, swapOff);
	    if (isSwappable) {
	        swapOn.setEnabled(false);
	        swapOff.setEnabled(true);
	        bar.getMenu(SWAP_MENUID).setEnabled(true);
	        //bar.getMenu(EDIT_MENUID).getItem(EDIT_EVENTS).setEnabled(false);
	        //bar.getMenu(EDIT_MENUID).getItem(EDIT_SWAPEVENTS).setEnabled(true);
	        frame.setTitle("SwapBox");
	    }else{
	        swapOn.setEnabled(true);
	        swapOff.setEnabled(false);
	        bar.getMenu(SWAP_MENUID).setEnabled(false);
	        //bar.getMenu(EDIT_MENUID).getItem(EDIT_EVENTS).setEnabled(true);
	        //bar.getMenu(EDIT_MENUID).getItem(EDIT_SWAPEVENTS).setEnabled(false);
	        frame.setTitle("BeanBox");
	    }
	    
	    editMenu.add(swappableMenu);
    }
    
    public void setEventsMenu (boolean enable) {
        eventsMenuEnable = enable;
    }
    
    void error(String message, Throwable th) {
        String mess = message + ":\n" + th;
        System.err.println(message);
        th.printStackTrace();

	    // Popup an ErrorDialog with the given error message.
	    new ErrorDialog(getFrame(), mess);
    }

    void error(String message) {
        System.err.println(message);
        // Popup an ErrorDialog with the given error message.
        new ErrorDialog(getFrame(), message);
    }
    
    void removeOne(Wrapper w) {
        synchronized(getTreeLock()) {
            Container parent = w.getParent();
            if (parent != null) {
                parent.remove(w);
            }
            w.cleanup();
            bcss.remove(w.getBean());
        }
    }
    
    /**
     * Create an event connection from source to target
     * Within this method, no additional method of Wrapper is used. The
     * Wrapper is sun.beanbox.Wrapper
     */

    void doEventHookup(ActionEvent evt) {
        
        String s;
        Wrapper sourceWrapper = BeanBoxFrame.getCurrentWrapper();
        AdapterCenter ac = AdapterCenter.getInstance();
	
	    // Code for hot-swapping
	    if (isSwappable) {
	        if ((s = ac.isInvalidWrapper(sourceWrapper)) != null) {
                new ErrorDialog(getFrame(), "The source bean has been swapped out. The new version is: " + s);
                return;
            }
        }
       

    	MenuItem mi = (MenuItem)evt.getSource();
	    Menu parent = (Menu)mi.getParent();

	    EventSetDescriptor esd = (EventSetDescriptor) eventMap.get(parent);
        Method meth = (Method) methodMap.get(mi);

	    if (esd == null || meth == null) {
	        return;
	    }

	    sun.beanbox.Wrapper targetWrapper = getConnection(sourceWrapper);
	    if (targetWrapper == null) {
	        return;
	    }
	
	    // Code for hot-swapping
	    if (isSwappable) {
	        if ((s = ac.isInvalidWrapper(targetWrapper)) != null) {
                new ErrorDialog(getFrame(), "The target bean has been swapped out. The new version is: " + s);
                return;
            }
            //setEventsMenu (false);
            new SwapEventTargetDialog(getFrame(), sourceWrapper, targetWrapper, esd, meth, parent.getLabel());
        } else {
            new EventTargetDialog(getFrame(), sourceWrapper, targetWrapper, esd, meth);
        }
    }
    
    public boolean getSmartMode() {
        return smartMode;
    }
    
    /**
     * Code for Hot-Swapping
     * Create an swap connection between old bean and new bean
     */
     
     void doSwapBind() {
        Wrapper sourceWrapper = BeanBoxFrame.getCurrentWrapper();
        Object bean = sourceWrapper.getBean();
        Calendar c;
        long st, et;
        
        Wrapper targetWrapper = getConnection(sourceWrapper);
        if (targetWrapper == null){
            String message = "The substitue bean is not \n"
                             + "an instance of Swappbale interface";
            new CancelSwapDialog (getFrame(), message);
        }else{
            try {
                /*if (type == Swap_Stateless) {
                    // (new SwapManager(targetWrapper, sourceWrapper, this)).swap_Stateless();
                } else if (type == Swap_Stateful) {*/
                FileDialog fd = new FileDialog(getFrame(), "Load Swap Transaction Descriptor", FileDialog.LOAD);
                fd.setDirectory(System.getProperty("user.dir"));
                fd.setFilenameFilter(new FileExtension("xml"));
                fd.show();
                String fname = fd.getFile();
                if (fname == null) {
                    return;
                }
                String dname = fd.getDirectory();
                //(new SwapManager(targetWrapper, sourceWrapper, this)).swap_Stateful(dname, fname);
                //System.out.println("I am going to invoke SwapConfigParser");
                AbstractSwapManager asm = (new SwapConfigParser(dname, fname)).selectSwapManager();
                asm.setOldWrapper(sourceWrapper);
                asm.setNewWrapper(targetWrapper);
                // asm.setSwapBox(this);
                c = Calendar.getInstance();
                st = convertToMills(c.get(Calendar.HOUR), c.get(Calendar.MINUTE), 
                                    c.get(Calendar.SECOND), c.get(Calendar.MILLISECOND));
                asm.swap(); 
                c = Calendar.getInstance();
                et = convertToMills(c.get(Calendar.HOUR), c.get(Calendar.MINUTE), 
                                    c.get(Calendar.SECOND), c.get(Calendar.MILLISECOND));
                new NoticeDialog (getFrame(), "The Swap Transaction Succeeds" + 
                                              "\nSwap time is: " + (et - st) + " mscs");
                
            } catch (SwapException se) {
                // System.out.println("The exception message is: " + se.getMessage());
                new ErrorDialog (getFrame(), "The Swap Transaction Fails\n" + se.getMessage());
            }
        }
     }
     
     void doConfig() {
        Wrapper sourceWrapper = BeanBoxFrame.getCurrentWrapper();
        Object Bean = sourceWrapper.getBean();
        
        Wrapper targetWrapper = getConnection(sourceWrapper);
        if (targetWrapper == null) {
             String message = "The substitue bean is not \n"
                             + "an instance of Swappbale interface";
            new CancelSwapDialog (getFrame(), message);
        }else{
            // new SwapConfigFrame(sourceWrapper, targetWrapper, getFrame().getLocation());
            // System.out.println("I am going to invoke SwapConfigEditor");
            new SwapConfigEditor(sourceWrapper, targetWrapper, getFrame().getLocation());
        }
     }
     
    protected void doMenuItem(ActionEvent evt) {
        
        MenuItem mi = (MenuItem)evt.getSource();
        Menu parent = (Menu)mi.getParent();
        String label = mi.getLabel();
        String parentLabel = parent.getLabel();
        
        //super.doMenuItem(evt);
        
        if(parentLabel.equals("Swappable")){
	        if (label.equals("On")) {
	            isSwappable = true;
	        } else {
	            isSwappable = false;
	        }
	        updateMenuBar(getFrame().getMenuBar());
	    } else if (parentLabel.equals("Verbose")) {
	        if (label.equals("On")) {
	            verbose = true;
	        } else {
	            verbose = false;
	            new NoticeDialog(getFrame(), "Be aware you have to configure the hot swapping policy file");
	        }
	        updateMenuBar(getFrame().getMenuBar());
	    } else if (parentLabel.equals("Smart Mode")) {
	        if (label.equals("On")) {
	            smartMode = true;
	            new NoticeDialog(getFrame(), "Be aware old and new states with the same name will be\n " 
	                                         + "automatically added to the hot swapping policy file");
	        } else {
	            smartMode = false;
	        }
	        updateMenuBar(getFrame().getMenuBar());
	    } else if (parentLabel.equals("Swap")) {
	        if (label.equals("Event Info")) {
	            new EventReportFrame(BeanBoxFrame.getCurrentWrapper());
	        } else if (label.equals("Swap")) {
	            doSwapBind();
	        /*}else if(label.equals("Swap")) {
	            doSwapBind(Swap_Stateless);
	        }else if(label.equals("Swap with State")) {
	            doSwapBind(Swap_Stateful);*/
	        }else if(label.equals("Config Swap")) {
	            doConfig();	            
	        }
	    } else if(parentLabel.equals("File") || parentLabel.equals("Edit") ||
	              parentLabel.equals("View") || parentLabel.equals("Services") ||
	              parentLabel.equals("Help")) {
	         
	         super.doMenuItem(evt);
	     } else {
	        doEventHookup(evt);
	     }
	}

    public Wrapper doInsert(Object bean, 
			 String beanLabel, 
			 String beanName, 
			 boolean useOldClick, 
			 boolean fromPrototype) {
	    // I made a change to the doInsert method at BeanBox so that it would be able to return
	    // Wrapper instead of void
	    Wrapper child = super.doInsert(bean, beanLabel, beanName, useOldClick, fromPrototype);
	    if (child == null ) {
	        return null;
	    }
	    if (isSwappable) {
	        if (verbose) {
	            new EnterNameFrame(child, getFrame().getLocation());
	        } else {
	            Calendar c = Calendar.getInstance(); 
                //et = convertToMills(c.get(Calendar.MINUTE), c.get(Calendar.SECOND), c.get(Calendar.MILLISECOND));
	            String name = "__" + bean.getClass().getName() + c.get(Calendar.DATE) 
	                        + c.get(Calendar.HOUR) + c.get(Calendar.MINUTE) + c.get(Calendar.SECOND); 
	            
	            //AdapterCenter.isNameValid(name, child);
	            AdapterCenter ac = AdapterCenter.getInstance();
	            ac.isNameValid(name, child);
	        }
	    }
	    return child;
	    
    }
    
    private long convertToMills(int hour, int minute, int second, int millis) {
        return (((((hour * 60) + minute) * 60 + second) * 1000) + millis);
    }
  
     protected static int SWAP_MENUID = 4;
     protected static int EDIT_EVENTS = 4;
     //protected static int EDIT_SWAPEVENTS = 5;
    
     private boolean isSwappable = true;
     private boolean eventsMenuEnable = true;
     private boolean verbose = true;
     private boolean smartMode = false;
     private final int Swap_Stateless = 1;
     private final int Swap_Stateful = 2;

}