package carleton.swapbox;

import sun.beanbox.*;
import java.awt.*;
import java.awt.event.*;

public class SwapConfigEditor extends Frame implements ActionListener {
    
    private Panel statePanel = null;
    private Button forwardButton, resetButton, abortButton, backwardButton;
    private SwapConfigState currentState;
    private Wrapper oldWrapper, newWrapper;
    
    public Button getForwardButton() {
        return forwardButton;
    }
    
    public Button getBackwardButton() {
        return backwardButton;
    }
    
    public Wrapper getOldWrapper() {
        return oldWrapper;
    }
    
    public Wrapper getNewWrapper() {
        return newWrapper;
    }
    
    public SwapConfigEditor(Wrapper oldWrapper, Wrapper newWrapper, Point p) {
        this.oldWrapper = oldWrapper;
        this.newWrapper = newWrapper;
        // System.out.println("I am getting into the SwapConfigEditor constructor");
        // super();
        setLocation(p);
        // System.out.println("I am after setting location of SwapConfigEditor");
        setLayout(null);
		setSize(433,487);
		setBackground(java.awt.Color.lightGray);
		setVisible(false);
		
		// statePanel.setLayout(null);
		// add(statePanel);
		// statePanel.setBounds(12,12,409,385);
		
		backwardButton = new Button();
		backwardButton.setLabel("Backward");
		add(backwardButton);
		backwardButton.setBackground(java.awt.Color.lightGray);
		backwardButton.setBounds(24,432,83,31);
		backwardButton.addActionListener(this);
		
		resetButton = new Button();
		resetButton.setLabel("Reset");
		add(resetButton);
		resetButton.setBackground(java.awt.Color.lightGray);
		resetButton.setBounds(120,432,83,31);
		resetButton.addActionListener(this);
		
		abortButton = new Button();
		abortButton.setLabel("Abort");
		add(abortButton);
		abortButton.setBackground(java.awt.Color.lightGray);
		abortButton.setBounds(216,432,83,31);
		abortButton.addActionListener(this);
		
		forwardButton = new Button();
		forwardButton.setLabel("Forward");
		add(forwardButton);
		forwardButton.setBackground(java.awt.Color.lightGray);
		forwardButton.setBounds(312,432,83,31);
		forwardButton.addActionListener(this);
		
		new WindowCloser(this);
		
		// setTitle("AWT Application");
		
        //lastState = SwapConfigState.lastState();
        //terminalState = SwapConfigState.terminalState();
        currentState = SwapConfigState.start(this);
        setVisible(true);
        // System.out.println("I am finishing instantialize the SwapConfigEditor");
    }
    
    public void handleEvent (SwapConfigEditorEvent scee) {
        // System.out.println("I am in the handleEvent method");
        // System.out.println("The current state is: " + currentState.toString());
        SwapConfigState scs = currentState.processEvent(scee);
        // System.out.println("After the processEvent, the currentState is: " + currentState.toString());
        if (scs != null) {
            currentState = scs;
            /*if (currentState instanceof MappingRulesState) {
                forwardButton.setLabel("Finish");
            }*/ 
            /*if (currentState instanceof TerminalState) {
                dispose();
            }*/ 
        }
    }
    
    public void actionPerformed (ActionEvent ae) {
        if (ae.getSource() == backwardButton) {
            handleEvent(new SwapConfigEditorEvent(SwapConfigEditorEvent.BACKWARD));
        } else if (ae.getSource() == resetButton) {
            handleEvent(new SwapConfigEditorEvent(SwapConfigEditorEvent.RESET));
        } else if (ae.getSource() == abortButton) {
            handleEvent(new SwapConfigEditorEvent(SwapConfigEditorEvent.ABORT));
        } else if (ae.getSource() == forwardButton) {
            // System.out.println("I am in the actionPerformed method, trying to invoke forwrd");
            handleEvent(new SwapConfigEditorEvent(SwapConfigEditorEvent.FORWARD));
        }
    }
  
    public void refresh(String title, Panel sPanel) {
        // System.out.println("Refresh method got invoked");
        if (title != null) {
            setTitle(title);
        }
        if (statePanel != null) {
            remove(statePanel);
        }
        add(sPanel);
        statePanel = sPanel;
        //show();
    }
    
    public void refresh(Panel sPanel) {
        refresh(null, sPanel);
    }
}