package carleton.swapbox;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.Vector;
import sun.beanbox.*;

public class SwapConfigFrame extends Frame {
    
    private Label timeLabel = new java.awt.Label();
	private TextField timeInput = new java.awt.TextField();
	private Panel panel1 = new java.awt.Panel();
	private Label oldStatesLabel = new java.awt.Label();
	private Label newStatesLabel = new java.awt.Label();
	private List oldStatesList = new java.awt.List(4);
	private List newStatesList = new java.awt.List(4);
	private Button addButton = new java.awt.Button();
	private TextArea xmlArea = new java.awt.TextArea();
	private Button finishButton = new java.awt.Button();
	private Button cancelButton = new java.awt.Button();
	
	private boolean[] oldStatesFlag;
	private boolean[] newStatesFlag;
	private String xmlStream;
	private Wrapper oldWrapper;
	private Wrapper newWrapper;
	
	public SwapConfigFrame(Wrapper oldWrapper, Wrapper newWrapper, Point p) {
		
		setLayout(null);
		setFont(new Font("Dialog", Font.BOLD, 14));
		setBackground(java.awt.Color.lightGray);
		setSize(348,510);
		setLocation(p);
		setVisible(false);
		
		timeLabel.setText("Time Constraint (ms):");
		add(timeLabel);
		timeLabel.setFont(new Font("Dialog", Font.PLAIN, 14));
		//timeLabel.setBounds(12,24,144,31);
		timeLabel.setBounds(12,36,144,31);
		
		add(timeInput);
		//timeInput.setBounds(156,24,144,24);
		timeInput.setBounds(156,36,144,24);
		timeInput.addActionListener(new TimeInputHandler());
		
		panel1.setLayout(null);
		add(panel1);
		panel1.setBounds(12,72,324,264);
		
		oldStatesLabel.setText("Available Old States");
		oldStatesLabel.setAlignment(java.awt.Label.CENTER);
		panel1.add(oldStatesLabel);
		oldStatesLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		oldStatesLabel.setBounds(12,12,120,24);
		
		newStatesLabel.setText("Available New States");
		newStatesLabel.setAlignment(java.awt.Label.CENTER);
		panel1.add(newStatesLabel);
		newStatesLabel.setFont(new Font("Dialog", Font.PLAIN, 12));
		newStatesLabel.setBounds(180,12,120,24);
		
		panel1.add(oldStatesList);
		oldStatesList.setBounds(12,48,119,160);
		oldStatesList.setMultipleMode(false);
		
		panel1.add(newStatesList);
		newStatesList.setBounds(180,48,119,160);
		newStatesList.setMultipleMode(false);
		
		addButton.setLabel("Add");
		panel1.add(addButton);
		addButton.setBackground(java.awt.Color.lightGray);
		addButton.setBounds(120,228,84,27);
		addButton.addActionListener(new AddButtonHandler());
		
		add(xmlArea);
		xmlArea.setBounds(24,348,302,105);
		xmlArea.setEditable(false);
		
		finishButton.setLabel("Finish");
		add(finishButton);
		finishButton.setBackground(java.awt.Color.lightGray);
		finishButton.setBounds(60,468,84,24);
		finishButton.addActionListener(new FinishButtonHandler(this));
		
		cancelButton.setLabel("Cancel");
		add(cancelButton);
		cancelButton.setBackground(java.awt.Color.lightGray);
		cancelButton.setBounds(192,468,84,24);
		cancelButton.addActionListener(new CancelButtonHandler());
		
		setTitle("Config Swap Transaction");
		//setVisible(true);
		new WindowCloser(this);
		
		this.oldWrapper = oldWrapper;
		this.newWrapper = newWrapper;
		Vector names = SwapConfigGenerator.analyzeOldVars(oldWrapper.getBean());
		if (names != null) {
		    for (int i = 0; i < names.size(); i++) {
		        oldStatesList.add((String)names.elementAt(i));
		    }
		}
		names = SwapConfigGenerator.analyzeNewVars(newWrapper.getBean());
		if (names != null) {
		    for (int i = 0; i < names.size(); i++) {
		        newStatesList.add((String)names.elementAt(i));
		    }
		}
		
		xmlStream = "<?xml version='1.0' encoding='us-ascii'?>\n" + "\n<swap>";
		xmlArea.setText(xmlStream + "\n</swap>");
		
		setVisible(true);
	}
	
	private class AddButtonHandler implements ActionListener {
	    public void actionPerformed (ActionEvent ae) {
	        String newState = newStatesList.getSelectedItem();
	        String oldState = oldStatesList.getSelectedItem();
	        xmlStream += "\n   <state newName=\"" + newState + "\" oldName=\"" + oldState + "\">" + "\n   </state>";
	        xmlArea.setText(xmlStream + "\n</swap>");
	    }
	}
	
	private class TimeInputHandler implements ActionListener {

	    public void actionPerformed (ActionEvent ae) {
	        String timeConstraint = timeInput.getText();
	        if (timeConstraint != null) {
	            timeConstraint.trim();
	            xmlStream +="\n   <time>" + timeConstraint.trim() + "</time>";
	            xmlArea.setText(xmlStream + "\n</swap>");
	        }
	    }
	}
	
	private class CancelButtonHandler implements ActionListener {
	    public void actionPerformed (ActionEvent ae) {
	        dispose();
	    }
	}
	
	private class FinishButtonHandler implements ActionListener {
	    private Frame frame;
	    
	    public FinishButtonHandler (Frame frame) {
	        this.frame = frame;
	    }
	    
	    public void actionPerformed (ActionEvent ae) {
	        String defaultStoreFile = "untitled.xml";
	        xmlStream += "\n</swap>";
	        FileDialog fd = new FileDialog(frame, "Save Swap Config File", FileDialog.SAVE);
	        // the setDirectory() is not needed, except for a bug under Solaris...
	        fd.setDirectory(System.getProperty("user.dir"));
	        fd.setFile(defaultStoreFile);
	        fd.show();
	        String fname = fd.getFile();
	        if (fname == null) {
	            return;
	        }
	        String dname = fd.getDirectory();
	        File file = new File(dname, fname);	  
	        
	        try {
	            // create the single ObjectOutputStream
	            FileWriter fileWriter = new FileWriter(file);
	            fileWriter.write(xmlStream, 0, xmlStream.length());
	            fileWriter.flush();
	            fileWriter.close();
	        } catch (Exception ex) {
	            new ErrorDialog (frame, "Error when save XML file");
	        }
	        frame.dispose();
	        //(new SwapManager(newWrapper, oldWrapper)).swap_Stateful(dname, fname);
	    }
   	}   
}

