package carleton.swapbox;

import java.lang.reflect.*;
import java.util.Vector;
import java.beans.*;

public class SwapConfigGenerator {
    public static Vector analyzeOldVars(Object oldBean) throws SwapException{
        
        // First get property
        Vector varNames = new Vector();
        Class c = oldBean.getClass();
        PropertyDescriptor properties[];
        
        try {
            BeanInfo bi = Introspector.getBeanInfo(oldBean.getClass());
            properties = bi.getPropertyDescriptors();
        } catch (IntrospectionException ex) {
            throw new SwapException("MappingRulesState: Couldn't introspect" + ex);
        }
        Method getter, setter;
        for (int i = 0; i < properties.length; ++i) {
            getter = properties[i].getReadMethod();
            setter = properties[i].getWriteMethod();
            if (getter != null && setter != null) {
                varNames.addElement(properties[i].getName());
            }
        }
        
        // Second get swapGet method
        Method[] methods = c.getMethods(); // Only return public methods
        String aMethodName;
        for (int i = 0; i < methods.length; i++) {
            aMethodName = methods[i].getName();
            if (aMethodName.startsWith("swapGet")) {
                boolean found = false;
                for (int j = 0; j < varNames.size(); ++j) {
                    if (((String)varNames.elementAt(j)).equalsIgnoreCase(aMethodName.substring(7))) {
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    varNames.addElement(aMethodName.substring(7));
                }
            }
        }
        return varNames;
    }
    
    public static Vector analyzeNewVars(Object newBean) throws SwapException{
        
        // First get property
        Vector varNames = new Vector();
        Class c = newBean.getClass();
        PropertyDescriptor properties[];
        
        try {
            BeanInfo bi = Introspector.getBeanInfo(newBean.getClass());
            properties = bi.getPropertyDescriptors();
        } catch (IntrospectionException ex) {
            throw new SwapException("MappingRulesState: Couldn't introspect" + ex);
        }
        Method getter, setter;
        for (int i = 0; i < properties.length; ++i) {
            getter = properties[i].getReadMethod();
            setter = properties[i].getWriteMethod();
            if (getter == null || setter == null) {
                continue;
            }
            varNames.addElement(properties[i].getName());
        }
        
        // Second get swapSet method
        Method[] methods = c.getMethods(); // Only return public methods
        String aMethodName;
        for (int i = 0; i < methods.length; i++) {
            aMethodName = methods[i].getName();
            if (aMethodName.startsWith("swapSet")) {
                boolean found = false;
                for (int j = 0; j < varNames.size(); ++j) {
                    if (((String)varNames.elementAt(j)).equalsIgnoreCase(aMethodName.substring(7))) {
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    varNames.addElement(aMethodName.substring(7));
                }
            }
        }
        return varNames;
    }
}
        