package carleton.swapbox;

import java.io.*;
import java.util.*;
import org.xml.sax.*;
import org.w3c.dom.*; 
import javax.xml.parsers.*;

public class SwapConfigParser {
    private File xmlFile;
    private Document document;
    
    public SwapConfigParser(String dirName, String fileName) throws SwapException {
        this(new File(dirName, fileName));
    }
    
    public SwapConfigParser(File xmlFile) throws SwapException {
        //Doceument document;
        DocumentBuilderFactory factory =
           DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(xmlFile);

        } catch (SAXParseException spe) {
            throw new SwapException("SwapManager: Parsing error, line " + spe.getLineNumber () +
                                    ", uri " + spe.getSystemId () + "   " + spe.getMessage());
        } catch (SAXException sxe) {
           throw new SwapException("SwapManager: An error occured when initialize XML parser" +
                                    "\n   " + sxe.getMessage());
        } catch (ParserConfigurationException pce) {
            throw new SwapException("SwapManager: Initialize new parser failed" + 
                                    "\n   " + pce.getMessage());
        } catch (IOException ioe) {
            throw new SwapException("SwapManager: I/O failed" + "\n   " + ioe.getMessage());
        }
    }
   
    
    public AbstractSwapManager selectSwapManager() throws SwapException{
        
        NodeList nodeList = document.getElementsByTagName("swap_type");
        if (nodeList.getLength() == 1 && nodeList.item(0).getNodeType() == Node.ELEMENT_NODE) {
            NodeList textNode = nodeList.item(0).getChildNodes();
            if (textNode.getLength() == 1 && textNode.item(0).getNodeType() == Node.TEXT_NODE
                && textNode.item(0).getNodeValue() != null) {
                    
                if (textNode.item(0).getNodeValue().equalsIgnoreCase("Default")) {
                    return new DefaultSwapManager(document);
                } else if (textNode.item(0).getNodeValue().equalsIgnoreCase("Option1")) {
                    return new Option1SwapManager(document);
                } else if (textNode.item(0).getNodeValue().equalsIgnoreCase("Option2")) {
                    return new Option2SwapManager(document);
                }
            }
        } else {
            throw new SwapException("SwapManager: Parsing swap_type failed");
        }
        return null;
    }
}