package carleton.swapbox;

import java.awt.*;

public abstract class SwapConfigState {
    
    protected static SwapConfigEditor editor;
    protected Panel statePanel;
    protected String panelTitle, xmlString;
    protected SwapConfigState nextState = null, previousState = null;
    
    public SwapConfigEditor getEditor() {
        return editor;
    }
    
    public void setPreviousState(SwapConfigState scs) {
        previousState = scs;
    }
    
    public SwapConfigState getPreviousState() {
        return previousState;
    }
    
    public void setNextState(SwapConfigState scs) {
        nextState = scs;
    }
    
    public SwapConfigState getNextState() {
        return nextState;
    }
    
    public Panel getPanel() {
        return statePanel;
    }
    
    public String getPanelTitle() {
        return panelTitle;
    }
    
    public abstract String getXMLString();
    
    public abstract void activate();
    
    public static SwapConfigState start(SwapConfigEditor sce) {
        editor = sce;
        SwapConfigState scs = new GeneralParesState();
        editor.refresh(scs.getPanelTitle(), scs.getPanel());
        return scs;
    }
    
    public SwapConfigState handleBackwardEvent() {
        if (previousState != null) {
            previousState.activate();
        }
        return previousState;
    }
    
    public SwapConfigState handleResetEvent() {
        return null;
    }
    
    public SwapConfigState handleAbortEvent() {
        return new TerminalState();
    }
    
    public SwapConfigState handleForwardEvent() {
        // System.out.println("The handleEvent at abstract class is invoked");
        return null;
    }
    
    public SwapConfigState processEvent(SwapConfigEditorEvent scee) {
        SwapConfigState scs = null;
        // System.out.println("The type of the Event is: " + scee.getType());
        switch (scee.getType()) {
            case SwapConfigEditorEvent.BACKWARD:
                scs = handleBackwardEvent();
                // editor.refresh(scs.getPanelTitle(), scs.getPanel());       
                break;
            case SwapConfigEditorEvent.RESET:
                scs = handleResetEvent();
                // editor.refresh(scs.getPanelTitle(), scs.getPanel());
                break;
            case SwapConfigEditorEvent.ABORT:
                scs = handleAbortEvent();
                // editor.refresh(scs.getPanelTitle(), scs.getPanel());
                break;
            case SwapConfigEditorEvent.FORWARD:
                scs = handleForwardEvent();
                // editor.refresh(scs.getPanelTitle(), scs.getPanel());
        }
        if (scs != null) {
            if (scs instanceof TerminalState) {
                editor.dispose(); 
            } else {
                editor.refresh(scs.getPanelTitle(), scs.getPanel());
            }
        }
        // System.out.println("The return state at processEvent is: " + scs);
        return scs;
    }
}