package carleton.swapbox;

import java.util.*;

public class SwapConfiguration {
    public static final int SWAP_STATEFULL = 0;
    public static final int SWAP_STATELESS = 1;
    public static final int SWAP_DEGRADED  = 2;
    
    private int swapType;
    private Vector newNames;
    private Vector oldNames;
    private long timeConstraint;
    
    public SwapConfiguration(int sT, Vector nNames, Vector oNames, long time) {
        swapType = sT;
        newNames = nNames;
        oldNames = oNames;
        timeConstraint = time;
    }
    
    public int getSwapType() {
        return swapType;
    }
    
    public Vector getNewNames() {
        return newNames;
    }
    
    public Vector getOldNames() {
        return oldNames;
    }
    
    public long getTimeConstraint() {
        return timeConstraint;
    }
}