package carleton.swapbox;

import java.awt.*;
import java.awt.event.*;
import sun.beanbox.*;

public class SwapEventDialog extends Frame implements ActionListener {
    private SwapReport aReport;
    private BeanBox bb;
    private java.awt.Label unchangedLabel;
	private java.awt.Label changedLabel;
	private java.awt.List unchangedList;
	private java.awt.List changedList;
	private java.awt.TextArea unchangedText;
	private java.awt.TextArea changedText;
	private java.awt.Button continueButton = new java.awt.Button();
	private java.awt.Button cancelButton = new java.awt.Button();
    
	public SwapEventDialog(SwapReport sr, BeanBox bb) {
	    aReport = sr;
	    this.bb = bb;
	    new WindowCloser(this);
	    
		setLayout(null);
		setSize(410,331);
		setVisible(false);
		
		unchangedLabel = new java.awt.Label();
		unchangedLabel.setText("Unchanged Events");
		unchangedLabel.setAlignment(java.awt.Label.CENTER);
		add(unchangedLabel);
		unchangedLabel.setFont(new Font("Dialog", Font.BOLD, 16));
		unchangedLabel.setBounds(36,18,168,36);
		//unchangedLabel.setBounds(36,12,168,36);
		
		changedLabel = new java.awt.Label();
		changedLabel.setText("Changed Events");
		changedLabel.setAlignment(java.awt.Label.CENTER);
		add(changedLabel);
		changedLabel.setFont(new Font("Dialog", Font.BOLD, 16));
		changedLabel.setBounds(216,18,168,36);
		//changedLabel.setBounds(216,12,168,36);
		
		unchangedList = new java.awt.List();
		add(unchangedList);
		//unchangedList.setBounds(36,72,172,25);
		unchangedList.setBounds(36,72,172,70);
		unchangedList.addActionListener(this);
		for (int i = 0; i < sr.getUnchangedEvents().size(); i++){
		    SwapEventInfo sei = (SwapEventInfo)(sr.getUnchangedEvents().elementAt(i));
		    unchangedList.add(sei.getEvent().getName());
		}
		
		changedList = new java.awt.List();
		add(changedList);
		//changedList.setBounds(216,72,172,25);
		changedList.setBounds(216,72,172,70);
		changedList.addActionListener(this);
		for (int i = 0; i < sr.getChangedEvents().size(); i++){
		    SwapEventInfo sei = (SwapEventInfo)(sr.getChangedEvents().elementAt(i));
		    changedList.add(sei.getEvent().getName());
		}
		
		unchangedText = new java.awt.TextArea();
		add(unchangedText);
		//unchangedText.setBounds(36,120,172,136);
		unchangedText.setBounds(36,157,172,68);
		
		changedText = new java.awt.TextArea();
		add(changedText);
		//changedText.setBounds(216,120,172,136);
		changedText.setBounds(216,157,172,68);
		
		continueButton = new java.awt.Button();
		continueButton.setLabel("Continue");
		add(continueButton);
		continueButton.setBackground(java.awt.Color.lightGray);
		continueButton.setFont(new Font("Dialog", Font.BOLD, 14));
		continueButton.setBounds(84,276,96,36);
		continueButton.addActionListener(this);
		
		cancelButton = new java.awt.Button();
		cancelButton.setLabel("Cancel");
		add(cancelButton);
		cancelButton.setBackground(java.awt.Color.lightGray);
		cancelButton.setFont(new Font("Dialog", Font.BOLD, 14));
		cancelButton.setBounds(240,276,96,36);
		//cancelButton.addActionListener(this);
		
		setTitle("SwapEventDialog");
		show();
		/*SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		//}}*/
	}
	
	public void actionPerformed (ActionEvent evt) {
	    if (evt.getSource() == continueButton) {
	        //AdapterCenter.removeOne(oldWrapper);
            //bb.removeOne(oldWrapper);
	        dispose();
	    }else if (evt.getSource() == cancelButton) {
	        System.exit(-1);
	    }else if (evt.getSource() == unchangedList) {
	        String s = unchangedList.getSelectedItem();
	        SwapEventInfo sei = aReport.getObjectFromName(s);
	        unchangedText.setText(sei.toString());
	    }else if (evt.getSource() == changedList) {
	        String s = changedList.getSelectedItem();
	        SwapEventInfo sei = aReport.getObjectFromName(s);
	        changedText.setText(sei.toString());
	    }	    
	}
	    
	
	/*public Frame1(String title)
	{
		this();
		setTitle(title);
	}
	
    /**
     * Shows or hides the component depending on the boolean flag b.
     * @param b  if true, show the component; otherwise, hide the component.
     * @see java.awt.Component#isVisible
     */
    public void setVisible(boolean b)
	{
		if(b)
		{
			setLocation(50, 50);
		}	
		super.setVisible(b);
	}
}

