package carleton.swapbox;

import java.beans.*;
import java.io.*;
import java.lang.reflect.Method;
import sun.beanbox.*;

public class SwapEventInfo implements Serializable {
    static final long serialVersionUID = 0;
    
    private Wrapper sourceWrapper;
    private Wrapper targetWrapper;
    private Object adapter;
    private EventSetDescriptor event;
    private Method targetMethod, listenerMethod;
    private String eventName;
    
    /**
      * Initialize an SwapEventInfo
      */
    public SwapEventInfo (Wrapper source, Wrapper target, Method lmd, Object hookupClass,
                          EventSetDescriptor esd, Method tmd, String eventName) {
        targetWrapper = target;
        sourceWrapper = source;
        listenerMethod = lmd;
        adapter = hookupClass;
        event = esd;
        targetMethod = tmd;
        this.eventName = eventName;
    }
    
    public String toString() {
        AdapterCenter ac = AdapterCenter.getInstance();
        String s;
        /*s = "Source: " + sourceWrapper.getBean().getClass().getName() + "\n"
          + "Target: " + targetWrapper.getBean().getClass().getName() + "\n"
          + "Event : " + event.getName() + "\n"
          + "Target Method: " + method.toString(); //getClass().getName();*/
          s = "Source: " + ac.getBeanName(sourceWrapper) + "\n"
          + "Target: " + ac.getBeanName(targetWrapper) + "\n"
          + "Event : " + eventName + "\n"
          + "Target Method: " + targetMethod.toString(); 
        return s;
    }
        
    public void setSource(Wrapper w) {
        sourceWrapper = w;
    }
    
    // Get source object
    public Wrapper getSource() {
        return sourceWrapper;
    }
    
    // Get target object
    public Wrapper getTarget() {
        return targetWrapper;
    }
    
    public void setTarget(Wrapper w) {
        targetWrapper = w;
    }
    
    public Method getListenerMethod() {
        return listenerMethod;
    }
    
    // Get adapter class name
    public Object getAdapter() {
        return adapter;
    }
    
    // Get event descriptor
    public EventSetDescriptor getEvent() {
        return event;
    }
    
    // Get method in the target bean
    public Method getTargetMethod() {
        return targetMethod;
    }
    
    public String getEventName() {
        return eventName;
    }
    
    /**
      * Determine if anObject is the source object in this piece of event info.
      * Only if anObject and source are referencing to the same object does 
      * return true. Any else cases, even if they are of the same class can not 
      * return true.
      */
    public boolean isSource (Object anObject) {
        /*System.out.println("I am at isSource method");
        System.out.println("The sourceBean is: " + sourceWrapper.getBean());
        System.out.println("The anObject is: " + anObject);*/
        if (sourceWrapper.getBean() == anObject) {
            return true;
        }else{
            return false;
        }
    }
    
    /**
      * Determine if anObject is the target object in this piece of event info.
      * Only if anObject and target are referencing to the same object does 
      * return true. Any else cases, even if they are of the same class can not 
      * return true.
      */
    public boolean isTarget (Object anObject) {
        if (targetWrapper.getBean() == anObject) {
            return true;
        }else{
            return false;
        }
    }
}
        
        
            
   
    