
package carleton.swapbox;

import java.awt.*;
import java.awt.event.*;
import java.lang.reflect.*;
import java.beans.*;
import sun.beanbox.*;

public class SwapEventTargetDialog extends EventTargetDialog {

    public SwapEventTargetDialog(Frame frame, Wrapper sourceWrapper, Wrapper targetWrapper,
			EventSetDescriptor esd, Method listenerMethod, String eventName) {
		 
	    super(frame, sourceWrapper, targetWrapper, esd, listenerMethod);
	    this.eventName = eventName;	   
	}
	    
	
    // Run is called in a sepaarte thread to actually complete a
    // requested event hookup.

    public void run() {
        int index = list.getSelectedIndex();

	    // Remove the current dialog, and put up a status line.	
	    removeAll();
	    Label status = new Label("Generating and compiling adaptor class");
	    add(status);
	    status.setBounds(20, getSize().height/2, getSize().width-30, 25);
	    repaint();

	    //HookupManager.hookup(esd, listenerMethod, sourceWrapper,
	    //		targetWrapper, methods[index].getMethod(), eventName);

        // Code for hot-swapping
        SwapHookupManager.hookup(esd, listenerMethod, sourceWrapper,
                targetWrapper, methods[index].getMethod(), eventName, false);
	    dispose();
    }

    // Code for Hot-Swapping
    private String eventName;
    //private Frame frame;
}
