// SwapHookupManager.class

package carleton.swapbox;

import java.util.*;
import java.beans.*;
import java.lang.reflect.*;
import sun.beanbox.*;

public class SwapHookupManager extends HookupManager {
    static void hookup(EventSetDescriptor esd,
		Method listenerMethod,
		Wrapper sourceWrapper,
		Wrapper targetWrapper,
		Method targetMethod,
		String eventName,
		boolean isSwapAdapter) {
    
        // code for hot-swapping, try to figure out if source and target are valid
        /*String s;
        if ((s = AdapterCenter.isInvalidWrapper(sourceWrapper)) != null) {
            new ErrorDialog(frame, "The source bean has been swapped out. The new version is: " + s);
            return;
        } else if ((s = AdapterCenter.isInvalidWrapper(targetWrapper)) != null) {
            new ErrorDialog(frame, "The target bean has been swapped out. The new version is: " + s);
            return;
        }*/

	    try {
	        // If we were smarter we might cache and reuse hookups.

	        Object source = sourceWrapper.getBean();
	        Object target = targetWrapper.getBean();
	        String hookupName = generateHookup(esd, listenerMethod, source, target, targetMethod, isSwapAdapter);

	        if (hookupName == null) {
		    // The compile failed.
	            System.err.println("Could not create event adaptor.");
		    return;
	        }

	        SimpleClassLoader loader = SimpleClassLoader.ourLoader;

	        javaFiles.addElement(hookupName);
 	        Class hookupClass = loader.loadClassFromFile(hookupName);
	        Object hookup = hookupClass.newInstance();

	        //Method setTargetMethod = findMethod(hookupClass, "setTarget");   
	        Method setTargetMethod = null;
	        Method methods[] = hookupClass.getDeclaredMethods();
	        for (int i = 0; i< methods.length; i++) {
	            if (methods[i].getName().equalsIgnoreCase("setTarget")) {
	                setTargetMethod = methods[i];
	                break;
	            }
	        }
	        Object args[] = new Object[1];
	        args[0] = target;
	        setTargetMethod.invoke(hookup, args);

    	    sourceWrapper.addEventTarget(esd.getName(), targetWrapper, hookup);
	        /**
	        * Code for Hot-Swapping
	        * add an object of SwapEventInfo into AdapterCenter
	        */
	        SwapEventInfo sei = new SwapEventInfo (sourceWrapper, targetWrapper, listenerMethod,hookup, esd, targetMethod, eventName);
	        
	        //AdapterCenter.addEntry(sei);
	        AdapterCenter ac = AdapterCenter.getInstance();
	        ac.addEntry(sei);
	        
	        ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(true);

	    } catch (InvocationTargetException ex) {
	        System.err.println("Hookup caught exception on target: " + ex.getTargetException());
	        ex.getTargetException().printStackTrace();
	    } catch (Exception ex) {
	        System.err.println("Hookup caught: " + ex);
	        ex.printStackTrace();
	    }

    }
    
    static String generateHookup(EventSetDescriptor esd, Method listenerMethod,
                                         Object source, Object target, Method targetMethod, boolean isSwapAdapter) {
    	String id = getId();
    	String className = "___Hookup_" + id;
    	String fileName = tmpDir + java.io.File.separator + className + ".java";
    	String targetType = target.getClass().getName();
    	Method methods[] = esd.getListenerMethods();
    	Class parameters[] = targetMethod.getParameterTypes();
    	
    	// Create an appropriate subdirectory.
    	java.io.File tmp = new java.io.File(tmpDir);
    	tmp.mkdirs();
    	
    	// Open the new java source file,
    	java.io.PrintWriter out = null;
    	try {
    	    java.io.FileWriter fout = new java.io.FileWriter(fileName);
    	    out = new java.io.PrintWriter(fout);
     	} catch (Exception ex) {
	        System.err.println("Couldn't open hookup file " + fileName);
	        System.err.println("   " + ex);
	        return null;
	    }
	    
	    out.println("// Automatically generated event hookup file.");
	    out.println("");
	    out.println("package " + packageName + ";");
	    
	    // These imports are in case the target or listener types are
	    // in the default package.
	    out.println("import " + targetType + ";");
	    out.println("import " + esd.getListenerType().getName() + ";");
	    
	    // Now do any imports on argument types.
	    Hashtable argt = new Hashtable();
	    argt.put(targetType, argt);
	    argt.put(esd.getListenerType().getName(), argt);
	    for (int k = 0; k < methods.length; k++) {
	        Class argTypes[] = methods[k].getParameterTypes();
	        for (int i = 0; i < argTypes.length; i++) {
	            Class type = argTypes[i];
	            while (type.isArray()) {
	                type = type.getComponentType();
		        }
		        if (type.isPrimitive()) {
		            continue;
		        }
		        String typeName = type.getName();
		        if (argt.get(typeName) == null) {	
		            out.println("import " + typeName + ";");
		            argt.put(typeName, argt);
		        }
	        }
	    }
	    
	    out.println("");
	    out.println("public class " + className + " implements " + 
	    			esd.getListenerType().getName() + ", " + "java.io.Serializable," +
	    		    "\n                                             carleton.swapbox.SwapAdapter, java.lang.Runnable {");
	    			
	    // code for creating constructor
	    out.println("");
	    out.println("    public " + className + "() {");
	    out.println("        aThread = new java.lang.Thread(this);");
	    out.println("        queue = new java.util.Vector();");
	    out.println("        queuedEvents = 0;");
	    out.println("        numOfArgs = " + parameters.length + ";");
	    if (isSwapAdapter) {
	        out.println("        inService = false;");
	        out.println("        block = true;");
	    } else {
	        out.println("        inService = true;");
	        out.println("        block = false;");
	    }
	    out.println("    }");
	    
	    // code for creating setTarget method
	    out.println("");
	    out.println("    public void setTarget(" + targetType + " t) {");
	    out.println("        target = t;");
	    out.println("        aThread.start();"); // We postpone this work later on when an event coming
	    out.println("    }");
	    
	    // code for creating all listener methods required by the interface 
	    for (int k = 0; k < methods.length; k++) {
	        out.println("");
	        out.print("    public void " + methods[k].getName() + "(");
	        Class argTypes[] = methods[k].getParameterTypes();
	        for (int i = 0; i < argTypes.length; i++) {
	            if (i > 0) {
	                out.print(", ");
	            }
	            // Figure out the string for the arguement type. We have
	            // to treat array types specially.
	            Class type = argTypes[i];
	            String typeName = "";
	            while (type.isArray()) {
	                typeName = "[]" + typeName;
	                type = type.getComponentType();
	            }
	            typeName = type.getName() + typeName;
	            out.print(typeName + " arg" + i);
	        }
	        out.print(")");
	        // code for creating throw Exception clause, if there is any
	        Class[] exceptionTypes = methods[k].getExceptionTypes();
	        if (exceptionTypes.length > 0) {
	            out.print("\n        throws");
	            for (int i = 0; i < exceptionTypes.length; i++) {
	                out.print(((i != 0) ? ", " : " ") + exceptionTypes[i].getName());
	            }
	        }
	        out.println(" {");
	        // if the method is the target method, we have to add some stuff at the method
	        if (listenerMethod.getName() == methods[k].getName()) {
	            //out.println("        System.out.println(inService);");
	            out.println("        if (!inService) {");
	            out.println("            return;");
	            out.println("        } else {");
	            out.println("            synchronized(this) {");
	            for (int i = 0; i < parameters.length; i++) {
	                out.println("                queue.addElement(arg" + i + ");");
	            }
	            out.println("                queuedEvents++;");
	            out.println("                if (queuedEvents == 1) {");
	            out.println("                    notify();");
	            out.println("                }");
	            out.println("            }");
	            out.println("        }");
	            out.println("    }");
	        }
	    }
	    
	    // code for creating setBlock method
	    out.println();
	    out.println("    public void setBlock(boolean b) {"
	              + "\n        synchronized(this) {"
	              + "\n            block = b;"
	              + "\n            if (!block) {"
	              + "\n                notify();"
	              + "\n            }"
	              + "\n        }"
	              + "\n    }");
	              
	    // code for creating setService method
	    out.println();
	    out.println("    public void setService(boolean b) {"
	              + "\n        inService = true;"
	              + "\n  }");
	    
	    // code for creating public void run() method
	    out.println("");
	    out.println("    public void run() {" 
	              + "\n        java.util.Vector v = new java.util.Vector();"
	              + "\n        int num = 0;"
	              + "\n        while(true) {"
	              + "\n            synchronized(this) {"
	              + "\n                if (queuedEvents == 0 || block) {"
	              + "\n                    try{"
	              + "\n                        wait();"
	              + "\n                    } catch (Exception ex) {"
	              + "\n                    }"
	              + "\n                } else {"
	              + "\n                    v.removeAllElements();"
	              + "\n                    for (int i = 0; i < queue.size(); i++) {"
	              + "\n                        v.addElement(queue.elementAt(i));;"
	              + "\n                    }"
	              + "\n                    queue.removeAllElements();"
	              + "\n                    num = queuedEvents;"
	              + "\n                    queuedEvents = 0;"
	              + "\n                 }"
	              + "\n            }"
	              + "\n            for (int i = 0; i < num; i++) {");
	     if (parameters.length == 0) {
	        out.println("                target." + targetMethod.getName() + "();");
	     } else {
	        for (int k = 0; k < parameters.length; k++) {
	            out.println("                " + parameters[k].getName() + " arg" + k + " = " 
	                    + "(" + parameters[k].getName() +")" + "v.elementAt(i*numOfArgs+" + k +");");  
	        }
	        out.print("                target." + targetMethod.getName() + "(");
	        for (int i = 0; i < parameters.length; i++) {
	            if (i > 0) {
	                out.print(" ,");
	            }
	            out.print("arg" + i);
	        }
	        out.println(");");
	     }
	     out.println("            }");
	     out.println("            num = 0;");
	     out.println("        }");
	     out.println("    }");
	     
	     out.println("");
	     out.println("    private " + targetType + " target;");
	     out.println("    private " + "java.lang.Thread aThread;");
	     out.println("    private " + "java.util.Vector queue;");
	     out.println("    private " + "int queuedEvents;");
	     out.println("    private " + "int numOfArgs;");
	     out.println("    private " + "boolean block;");
	     out.println("    private " + "boolean inService;");
	     out.println("}");
	     out.close();
	     
	     //System.out.println("adapter file name is: " + fileName);
	     //System.out.println("pathfromloadedFiles is: " + pathFromLoadedJarFiles());
	     boolean ok = ClassCompiler.compile(fileName, pathFromLoadedJarFiles());	
	     if (!ok) {
	        return null;
	     }
	     
	     String fullClassName = packageName+"."+className;
	     String pathToFile = tmpDir+java.io.File.separatorChar+className+".class";
	     return pathToFile;
    }
}
	                                     
	                                     
	     
	        
	            
	            
	     
	          
	                    
	    
	    

    