package carleton.swapbox;

import java.util.*;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import sun.beanbox.*;

public class SwapManager_Stateful extends AbstractSwapManager {
    public SwapManager_Stateful (SwapConfiguration config) {
        oldWrapper = null;
        newWrapper = null;
        this.config = config;
    }
    
    public void swap() throws SwapException {
        if (oldWrapper == null || newWrapper == null) {
            throw new SwapException("SwapManager_Statefull: not both wrappers are not null");
        }
        
        Object newBean = newWrapper.getBean();
        Object oldBean = oldWrapper.getBean();
        
        preSwapProcess();
        
        try {
            //createStatesForNewBean(xmlDName, xmlFName);
            createStatesForNewBean();
        } catch (SwapException se) {
            unblockService(oldWrapper);
            cleanup(newWrapper);
            ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(true);
            throw se;
        }
        
        Method[] newMethods = newBean.getClass().getDeclaredMethods();
        boolean found = false;
        for (int i = 0; i < newMethods.length; i++) {
            if (newMethods[i].getName().equalsIgnoreCase("swapMethod")) {
                try {
                    Object args[] = {};
                    newMethods[i].invoke(newBean, args);
                    unblockService(newWrapper);
                } catch (Exception ex) {
                    unblockService(oldWrapper);
                    cleanup(newWrapper);
                    ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(true);
                    throw new SwapException("SwapManager: Invoke method at new Module failed" +
                                            "\n   " + ex.getMessage());
                }
                found = true;
                break;
            }
        }
        
        if (!found) {
            throw new SwapException("SwapManager: There is no swapMethod() at the new S-Module");
        }
        cleanup(oldWrapper);
        ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(false);
    }     
}