package carleton.swapbox;

/**
  * Code for Hot-Swapping
  * This class is used to encapsulate comparing result before a swap transaction
  * happening. The result will be used in reconstruct event communications
  */
import java.util.*;
import java.io.*;

public class SwapReport implements Serializable{
    static final long serialVersionUID = 0;
    
    private Vector unchangedEvents;
    private Vector changedEvents;
    
    /**
      * Initialize an SwapReport
      */
    public SwapReport() {
        unchangedEvents = new Vector();
        changedEvents = new Vector();
    }
    
    public void setUnchagnedEvents (Vector v) {
        unchangedEvents = v;
    }
    
    public void setChangedEvents (Vector v) {
        changedEvents = v;
    }
    
    public void addUnchangedEvent (SwapEventInfo sei) {
        unchangedEvents.addElement(sei);
    }
    
    public void addChangedEvent (SwapEventInfo sei) {
        changedEvents.addElement(sei);
    }
    
    public Vector getUnchangedEvents() {
        return unchangedEvents;
    }
    
    public Vector getChangedEvents () {
        return changedEvents;
    }
    
    public SwapEventInfo getObjectFromName (String s) {
        SwapEventInfo sei = null;
        boolean found = false;
        for (int i = 0; i < unchangedEvents.size() && !found; i++){
            sei = (SwapEventInfo)unchangedEvents.elementAt(i);
            if (sei.getEvent().getName().equals(s)){
                found = true;
            }
        }
        for (int i = 0; i < changedEvents.size() && !found; i++){
            sei = (SwapEventInfo)changedEvents.elementAt(i);
            if (sei.getEvent().getName().equals(s)){
                found = true;
            }
        }
        return sei;
    }
    
        
    public void print(){
        System.out.println("Unchanged Events:");
        for (int i = 0; i < unchangedEvents.size(); i++){
            SwapEventInfo sei = (SwapEventInfo)unchangedEvents.elementAt(i);
            System.out.println(sei.getEvent().getName());
        }
        System.out.println("-------------------------------------------------");
        System.out.println("Changed Events:");
        for (int i = 0; i < changedEvents.size(); i++){
            SwapEventInfo sei = (SwapEventInfo)changedEvents.elementAt(i);
            System.out.println(sei.getEvent().getName());
        }
    }
}
        
        