package carleton.swapbox;

public class Timer implements Runnable {
    
    private TimerRequester ref;
    private long timeLength;
    private boolean periodic;
    private boolean stop;
    
    public Timer(TimerRequester obj) {
        ref = obj;
        stop = false;
    }
    
   public void request(long time, boolean p) {
        timeLength = time;
        periodic = p;
        (new Thread(this)).start();
    }
    
    public synchronized void cancelRequest() {
        stop = true;
    }
    
    public void run() {
        do {
            try {
                Thread.sleep(timeLength);
            } catch (InterruptedException e) {}
            synchronized(this) {
                if (!stop) {
                    ref.timeUp();
                }
            }
        } while (periodic && !stop);
    }
}
    