import java.util.*;

public class QuickSort implements BeginSortingListener{
    private long st;
    private int[] data;
	private Vector listener_SortingDone;
    
    public QuickSort () {
		listener_SortingDone = new Vector();
    }
	
	public void swapSetData(int[] data) {
	    this.data = new int[data.length];
	    for (int i = 0; i < data.length; i++) {
	        this.data[i] = data[i];
	    }
	}
	
	public int[] swapGetData() {
	    return data;
	}
	
	public void swapMethod() {
	    sort(data);
	    data = null;
	}
	
	public synchronized void addSortingDoneListener (SortingDoneListener l) {
	    //System.out.println("The addSortingDoneListener method at QuickSort class is invoked");
		listener_SortingDone.addElement(l);
	}
	
	public synchronized void removeSortingDoneListener (SortingDoneListener l) {
		listener_SortingDone.removeElement(l);
	}		
    
    public void sort(SortingEvent e) {
        //System.out.println("A sortingEvent is goten");
        st = e.getStartTime();
		data = e.getData();
		sort(data);
    }
    
    private void sort (int[] d) {
        //System.out.println("Begin to Sort");
        qSort(d, 0, d.length - 1);
        //System.out.println("After sort");
		Vector v;
		synchronized (this) {
			v = (Vector)listener_SortingDone.clone();
		}
		for (int i = 0; i < v.size(); i++) {
			SortingDoneListener s = (SortingDoneListener)v.elementAt(i);
			SortingEvent ee = new SortingEvent(this, d);
			ee.setStartTime(st);
			s.update(ee);
		}
    }        
    
    private void qSort(int[] a, int low, int high) {
        if (low < high) {
            int pivotloc = split(a, low, high);
            //System.out.println("The split location is: " + pivotloc);
            //System.out.println("The split value is   : " + a[pivotloc]);
            qSort(a, low, pivotloc - 1);
            qSort(a, pivotloc + 1, high);
        }
    }
    
    private int split(int[] a, int low, int high) {
        int pivotkey = a[low];
		int first = low;
        
		low++;
        while (low <= high) {
            while (low <= high && a[low] < pivotkey) {
                ++low;
			}
            while (low <= high && a[high] > pivotkey) {
                --high;
			}
			if (low <= high) {
				int temp = a[low];
				a[low] = a[high];
				a[high] = temp;
				++low;
				--high;
			}
        }
		int temp = a[high];
		a[high] = a[first];
		a[first] = temp;
		return high;
    }
    
    /*public static void main(String args[]) {
        //BubbleSort bs;
        QuickSort qs;
        Random r = new Random();
		int size = 7;
        //int[] a = new int[size];
		int[] a = {5,6,4,3,2,1,7};
        //int[] sortedA = new int[size];
        
        System.out.println("The unsorted array is: ");
        for (int i = 0; i < size; i++) {
            //a[i] = r.nextInt() % 10000;
            System.out.println(a[i]);
        }
        
        bs = new BubbleSort(a);
        sortedA = bs.sort();
        System.out.println("\nThe sorted array by bubble sort is: ");
        for (int i = 0; i < size; i++) {
            System.out.println(sortedA[i]);
        }
        
        qs = new QuickSort();
        qs.sort(a);
        System.out.println("\nThe sorted array by quick sort is: ");
        for (int i = 0; i < size; i++) {
            System.out.println(a[i]);
        }
		System.out.println("");
    }*/ 
}