/*
	This simple extension of the java.awt.Frame class
	contains all the elements necessary to act as the
	main window of an application.
 */

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

public class SortAlgorithmFrame extends Panel implements SortingDoneListener, Runnable {
	public SortAlgorithmFrame()
	{
		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.
		
		//{{INIT_CONTROLS
		super();
		setLayout(null);
		setBackground(java.awt.Color.lightGray);
		setForeground(new java.awt.Color(0,128,255));
		setSize(373,384);
		setVisible(false);
		label1.setText("Original List");
		label1.setAlignment(java.awt.Label.CENTER);
		add(label1);
		label1.setBounds(60,24,73,33);
		label2.setText("Sorted List");
		add(label2);
		label2.setBounds(228,24,73,33);
		
		originalList.setBounds(60,72,60,192);
		//originalList.setPrototypeCellValue("xxxxxx");
		add(originalList);
		//add(new JScrollPane(originalList));
		
		sortedList.setBounds(228,72,60,192);
		//sortedList.setPrototypeCellValue("xxxxxx");
		add(sortedList);
		//add(new JScrollPane(sortedList));
		
		label3.setText("List Size");
		label3.setAlignment(java.awt.Label.CENTER);
		add(label3);
		label3.setBounds(36,288,60,33);
		
		add(listsizeField);
		listsizeField.setBounds(108,288,110,31);
		listsizeField.addActionListener(new ListsizeHandler());
		
		generateButton.setLabel("Generate");
		add(generateButton);
		generateButton.setForeground(java.awt.Color.black);
		generateButton.setBounds(252,288,84,36);
		generateButton.addActionListener(new GenerateButtonHandler());
		
		label4.setText("Time Used");
		label4.setAlignment(java.awt.Label.CENTER);
		add(label4);
		label4.setBounds(24,336,72,33);
		add(timeField);
		timeField.setBounds(108,336,186,31);
		
		setVisible(true);
		
		listeners_BeginSorting = new Vector();
		incomingEvents = new Vector();
		lock = new Object();
		(new Thread(this)).start();
	}
	
	/*public SortAlgorithmFrame(String title)
	{
		this();
		setTitle(title);
	}*/
	
    /**
     * Shows or hides the component depending on the boolean flag b.
     * @param b  if true, show the component; otherwise, hide the component.
     * @see java.awt.Component#isVisible
     */
    public void setVisible(boolean b)
	{
		if(b)
		{
			setLocation(50, 50);
		}	
		super.setVisible(b);
	}
	
	static public void main(String args[])
	{
	    SortAlgorithmFrame frame = null;
		try
		{
			//Create a new instance of our application's frame, and make it visible.
			frame = new SortAlgorithmFrame();
    		frame.setVisible(true);
		}
		catch (Throwable t)
		{
			System.err.println(t);
			t.printStackTrace();
			//Ensure the application exits with an error condition.
			System.exit(1);
		}
		/*frame.addWindowListener( 
           new WindowAdapter() { 
              public void windowClosing(WindowEvent e) { 
                     System.exit(0); 
                 } 
              } 
         );*/ 
	}
	
	/*public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension d = getSize();
		
		super.addNotify();
	
		if (fComponentsAdjusted)
			return;
	
		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}
	
	// Used for addNotify check.
	boolean fComponentsAdjusted = false;*/
	
	//{{DECLARE_CONTROLS
	java.awt.Label label1 = new java.awt.Label();
	java.awt.Label label2 = new java.awt.Label();
	java.awt.List originalList = new java.awt.List();
	java.awt.List sortedList = new java.awt.List();
	//javax.swing.JList originalList = new javax.swing.JList();
	//javax.swing.JList sortedList = new javax.swing.JList();
	java.awt.Label label3 = new java.awt.Label();
	java.awt.TextField listsizeField = new java.awt.TextField();
	java.awt.Button generateButton = new java.awt.Button();
	java.awt.Label label4 = new java.awt.Label();
	java.awt.TextField timeField = new java.awt.TextField();
	Vector listeners_BeginSorting;
	Calendar c;
    long st, et;
    Vector incomingEvents;
    Object lock;
	//}}
	
	//{{DECLARE_MENUS
	//}}
	
	/*class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == SortAlgorithmFrame.this)
				SortAlgorithmFrame_WindowClosing(event);
		}
	}*/
	
	/*void SortAlgorithmFrame_WindowClosing(java.awt.event.WindowEvent event)
	{
		// to do: code goes here.
	}*/

	
	/*class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			
		}
	}*/
	
	public synchronized void addBeginSortingListener(BeginSortingListener l){
	    //System.out.println("I am getting into the addBeginSortingListener() method of frame");
	    listeners_BeginSorting.addElement(l);
	    //System.out.println("The algorithm is registered in the frame");
	}
	
	public synchronized void removeBeginSortingListener(BeginSortingListener l){
	    for (int i = 0; i < listeners_BeginSorting.size(); i++) {
	        if (l == (BeginSortingListener)listeners_BeginSorting.elementAt(i)) {
	            listeners_BeginSorting.removeElement(l);
	            return;
	        }
	    }
	}
	
	/*public void update(SortingEvent e) {
	    c = Calendar.getInstance(); 
        et = convertToMills(c.get(Calendar.MINUTE), c.get(Calendar.SECOND), c.get(Calendar.MILLISECOND));
        timeField.setText("A sorting done event is gotten");
	    int[] data = e.getData();
	    Integer[] dataObject = new Integer[data.length];
	    for (int i = 0; i < data.length; i++) {
	        dataObject[i] = new Integer(data[i]);
	        sortedList.add(dataObject[i].toString());
	    }
	    timeField.setText((new Long(et - e.getStartTime())).toString() + " milliseconds");
	    //sortedList.setListData(dataObject);
	}*/
	
	public synchronized void update(SortingEvent e) {
	    c = Calendar.getInstance(); 
        et = convertToMills(c.get(Calendar.MINUTE), c.get(Calendar.SECOND), c.get(Calendar.MILLISECOND));
        /*timeField.setText("A sorting done event is gotten");
	    int[] data = e.getData();
	    Integer[] dataObject = new Integer[data.length];
	    for (int i = 0; i < data.length; i++) {
	        dataObject[i] = new Integer(data[i]);
	        sortedList.add(dataObject[i].toString());
	    }
	    timeField.setText((new Long(et - e.getStartTime())).toString() + " milliseconds");*/
	    //sortedList.setListData(dataObject);
	    incomingEvents.add(e);
	    incomingEvents.add(new Long(et-e.getStartTime()));
	    if (incomingEvents.size() == 2) {
	        synchronized (lock) {
	            lock.notify();
	        }
	    }
	}
	
	public void run() {
	    SortingEvent e;
	    Long sortingTime;
	    	    
	    while (true) {
	        synchronized (lock) {
	            try {
	                if (incomingEvents.size() == 0) {
	                    lock.wait();
	                } else {
	                    Thread.sleep(5000);
	                }
	            } catch (InterruptedException ie) {}
	            e = (SortingEvent)incomingEvents.remove(0);
	            sortingTime = (Long)incomingEvents.remove(0);
	        }
	        timeField.setText("A sorting done event is gotten");
	        int[] data = e.getData();
	        Integer[] dataObject = new Integer[data.length];
	        for (int i = 0; i < data.length; i++) {
	            dataObject[i] = new Integer(data[i]);
	            sortedList.add(dataObject[i].toString());
	        }
	        timeField.setText(sortingTime.toString() + " milliseconds");
	        /*if (incoingEvents.size() != 0) {
	            Thread.sleep(5000);
	        }*/
	    }
	}
	
	private void beginSortingHelper (ActionEvent e) {
	    Vector v;
	    int dataRange = 100000;
	    int[] data;
	    Integer[] dataObject;
	    timeField.setText("");
	    System.out.println("I am going to remove all items from originalList");
	    originalList.removeAll();
	    sortedList.removeAll();
	      
	    try {
	        int size = (new Integer(listsizeField.getText())).intValue();
	        data = new int[size];
	        dataObject = new Integer[size];
	    }catch (NumberFormatException nfe) {
	        timeField.setText("You should input a size");
	        return;
	    }
	    timeField.setText("Begin displaying original recprds");
	    Random r = new Random();
	    for (int i = 0; i < data.length; i++) {
	        data[i] = r.nextInt() % dataRange;
	        dataObject[i] = new Integer(data[i]);
	        originalList.add(dataObject[i].toString());
	    }
	    //originalList.setListData(dataObject);
	 
	    synchronized (this) {
	       if (listeners_BeginSorting.size() != 0) {
	            v = (Vector)listeners_BeginSorting.clone();
	        }else{
	            v = null;
	        }
	    }
	    if (v == null) {
	        timeField.setText("There is no algorithm available");
	        return;
	    }
	    for (int i = 0; i < v.size(); i++) {
	        BeginSortingListener b = (BeginSortingListener)v.elementAt(i);
	        SortingEvent ee = new SortingEvent(this,data);
	        //System.out.println("A sorting event sent out");
	        timeField.setText("A begin sorting event is sent out");
	        c = Calendar.getInstance();
            st = convertToMills(c.get(Calendar.MINUTE), c.get(Calendar.SECOND), c.get(Calendar.MILLISECOND));
            ee.setStartTime(st);
            
	        b.sort(ee);
	        //System.out.println("Sorting Algorithm: " + b);
	    }
	}
	    
	
	private class GenerateButtonHandler implements ActionListener{
	    public void actionPerformed (ActionEvent e) {
	        beginSortingHelper(e);
	    }
	}
	
	private class ListsizeHandler implements ActionListener {
	    public void actionPerformed(ActionEvent e) {
	        beginSortingHelper(e);
	    }
	}
	
	private long convertToMills(int minute, int second, int millis) {
        return (((minute * 60 + second) * 1000) + millis);
    }
	        
	
	/*private class MyWindowListener implements WindowListener {
	    public void windowClosed(WindowEvent e) {
	        System.exit(0);
	    }
	}*/
}

