#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <cilk/cilk.h>

using namespace std;

//--- Input parameters
#define arrayLength 100000  // 100000
#define loopLength  500     // 500

//--- time of day in ns
unsigned long long todval (struct timeval *tp) {
    return tp->tv_sec * 1000 * 1000 + tp->tv_usec;
}

//--- function calculation; time = O(loopLength^2)
inline short f(long long i) 
   {
       long long s=0;
       for (long long t=0;t<loopLength;t++)
          for (long long u=0;u<loopLength;u++)
			{s=s*t+u+i;};
	   return( (short)((i+s)%1000) );
	};

//--- MAIN ---
int main(){

	cout << "Calculating a[i] = f(i), 0 <= i < " << arrayLength << endl;
	cout << "where f(i) takes time O(" << loopLength << "^2)." << endl << endl;
		
	short * a = new short[arrayLength];	
		
	//--- Calculating in parallel
	cout << "Calculating in parallel..." << endl;
    struct timeval t1, t2;
    gettimeofday(&t1,0);
	cilk_for (long long i=0; i<arrayLength; i++)
		{
			a[i] = f(i);
		};
    gettimeofday(&t2,0);
    unsigned long long runtime_ms_P = (todval(&t2)-todval(&t1))/1000;
	cout << "Parallel run time: " << runtime_ms_P << "ns" << endl;

	//--- Calculating sequentially
	cout << "Calculating sequentially..." << endl;
    gettimeofday(&t1,0);
	for (long long i=0; i<arrayLength; i++)
		{
			a[i] += f(i);
		};
    gettimeofday(&t2,0);
    unsigned long long runtime_ms_S = (todval(&t2)-todval(&t1))/1000;
	cout << "Sequential run time: " << runtime_ms_S << " ms" << endl;
	cout << "Speedup: " << (float)runtime_ms_S/runtime_ms_P << endl;

}


