#include <cstdlib>
#include <iostream>
#include <omp.h>
using namespace std;

//--- Input parameters
#define number 30  // fib(number)


long fib(long n) {
  if (n < 2)
    return n;
  long x,y;  
  #pragma omp task shared(x,n)
	x = fib(n-1); 
  #pragma omp task shared(y,n)
	y = fib(n-2);
  #pragma omp taskwait  
  return x + y;
}


//--- MAIN ---
int main(){

	long result;
		
	//--- Calculating in parallel
	cout << "Calculating in parallel..." << endl;
	double startTime = omp_get_wtime();
	#pragma omp parallel 
	{
		result = fib(number);
	};		
	double endTime = omp_get_wtime(); 
	double parallelTime = endTime - startTime;
	cout << "fib(" << number << ") = " << result << endl;
	cout << "Parallel run time: " << parallelTime << " seconds" << endl << endl;

	//--- Calculating sequentially
	cout << "Calculating sequentially..." << endl;
	startTime = omp_get_wtime();
	result = fib(number);
	endTime = omp_get_wtime(); 
	double sequentialTime = endTime - startTime;
	cout << "fib(" << number << ") = " << result << endl;	
	cout << "Sequential run time: " << sequentialTime << " seconds" << endl << endl;

	cout << "Speedup: " << (sequentialTime / parallelTime) << endl;
}


