#include <cstdlib>
#include <iostream>
#include <omp.h>
using namespace std;

//--- Machine parameters
#define numberOfCores 6                            // 6
#define numberOfHardwareSupportedThreadsPerCore 2  // 2
#define latencyHidingThreadMultiplier 2            // 8

//--- Input parameters
#define arrayLength 100000  // 100000
#define loopLength  500     // 500

//--- function calculation; time = O(loopLength^2)
inline short f(long long i) 
   {
       long long s=0;
       for (long long t=0;t<loopLength;t++)
          for (long long u=0;u<loopLength;u++)
			{s=s*t+u+i;};
	   return( (short)((i+s)%1000) );
	};

//--- MAIN ---
int main(){

	cout << "Calculating a[i] = f(i), 0 <= i < " << arrayLength << endl;
	cout << "where f(i) takes time O(" << loopLength << "^2)." << endl;
	cout << "Number of cores: " << numberOfCores << endl;

	//--- Set number of threads
	int numberOfThreads = numberOfCores * numberOfHardwareSupportedThreadsPerCore
		* latencyHidingThreadMultiplier;	
	omp_set_num_threads(numberOfThreads);
	cout << "Number of threads: " << numberOfThreads << endl << endl;
	int numberOfActualThreads;
		
	short * a = new short[arrayLength];	
		
	//--- Calculating in parallel
	cout << "Calculating in parallel..." << endl;
	double startTime = omp_get_wtime();
	#pragma omp parallel 
	{
		if (omp_get_thread_num()==0) 
		{
			numberOfActualThreads = omp_get_num_threads();
		};
		
		#pragma omp for 
		for (long long i=0; i<arrayLength; i++)
		{
			a[i] = f(i);
		};
	};		
	double endTime = omp_get_wtime(); 
	double parallelTime = endTime - startTime;
	
	cout << "Actual number of threads: " << numberOfActualThreads << endl;
	cout << "Parallel run time: " << parallelTime << " seconds" << endl << endl;


	//--- Calculating sequentially
	cout << "Calculating sequentially..." << endl;
	startTime = omp_get_wtime();
	for (long long i=0; i<arrayLength; i++)
	{
	   a[i] = f(i);
	};		
	endTime = omp_get_wtime(); 
	double sequentialTime = endTime - startTime;
	
	cout << "Sequential run time: " << sequentialTime << " seconds" << endl << endl;
	cout << "Speedup: " << (sequentialTime / parallelTime) << endl;

}


