#include <cstdlib>
#include <iostream>
#include <omp.h>
using namespace std;

//--- Machine parameters
#define numberOfCores 2
#define numberOfHardwareSupportedThreadsPerCore 2
#define latencyHidingThreadMultiplier 2

//--- MAIN ---
int main(){
	
	//--- Set default number of threads
	int numberOfThreads = numberOfCores * numberOfHardwareSupportedThreadsPerCore
		* latencyHidingThreadMultiplier;	
	omp_set_num_threads(numberOfThreads);
	cout << endl << "Default number of threads: " << numberOfThreads << endl;
	
	//--- Set start time for run time calculation
	double startTime = omp_get_wtime();
		
	//--- Run parallel threads
	#pragma omp parallel //num_threads(6) //(change number of threads)
	{
		int i = omp_get_thread_num();
		int n = omp_get_num_threads();
		
		#pragma omp critical //general version of "atomic"
		{
		cout << "Thread " << i << " of " << n << endl;
		}
	}	
	
	//--- Report run time
	double endTime = omp_get_wtime(); 
	cout << "Run time: " << (endTime - startTime) << " seconds" << endl;

}


