/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA;

import java.util.ArrayList;
import java.util.List;
import org.JIFSA.AgentAction;
import org.JIFSA.AgentInputs;
import org.JIFSA.Case;
import org.JIFSA.CaseBase;
import org.JIFSA.preprocessing.filters.CaseFilter;
import org.JIFSA.reasoning.actionselection.ActionSelection;
import org.JIFSA.reasoning.casebasesearch.CaseBaseSearch;

public class Agent {
    private CaseBase m_caseBase;
    private CaseBaseSearch m_cbSearch;
    private ActionSelection m_actionSelection;
    private CaseFilter[] m_filters;

    public Agent(CaseBase caseBase, CaseBaseSearch caseBaseSearch, ActionSelection actionSelection) {
        if (caseBase == null) {
            throw new IllegalArgumentException("Null CaseBase given to Agent.");
        }
        if (caseBase.getCasebaseSize() == 0) {
            throw new IllegalArgumentException("Empty CaseBase given to Agent. At least one Case must be in CaseBase.");
        }
        if (caseBaseSearch == null) {
            throw new IllegalArgumentException("Null CaseBaseSearch given to Agent.");
        }
        if (actionSelection == null) {
            throw new IllegalArgumentException("Null ActionSelection given to Agent.");
        }
        this.m_caseBase = caseBase;
        this.m_cbSearch = caseBaseSearch;
        this.m_actionSelection = actionSelection;
        this.m_filters = new CaseFilter[0];
    }

    public AgentAction senseEnvironment(AgentInputs agentInputs) {
        if (agentInputs == null) {
            throw new IllegalArgumentException("Null AgentInputs given to Agent.");
        }
        Case case_ = new Case(agentInputs, new ArrayList<AgentAction>());
        for (int i = 0; i < this.m_filters.length; ++i) {
            case_ = this.m_filters[i].filter(case_);
        }
        List<Case> list = this.m_cbSearch.findClosest(case_, this.m_caseBase);
        return this.m_actionSelection.selectAction(list);
    }

    public void setFilters(CaseFilter[] caseFilterArray) {
        for (int i = 0; i < caseFilterArray.length; ++i) {
            if (caseFilterArray[i] != null) continue;
            throw new IllegalArgumentException("Null CaseFilter given to agent.");
        }
        this.m_filters = caseFilterArray;
    }

    public void setCaseBase(CaseBase caseBase) {
        if (caseBase == null) {
            throw new IllegalArgumentException("Null CaseBase given to Agent.");
        }
        if (caseBase.getCasebaseSize() == 0) {
            throw new IllegalArgumentException("Empty CaseBase given to Agent. At least one Case must be in CaseBase.");
        }
        this.m_caseBase = caseBase;
    }
}

