/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.JIFSA.SensoryItem;

public class AgentInputs
implements Serializable {
    private static final long serialVersionUID = -6016212103321562592L;
    private Hashtable<String, List<SensoryItem>> m_featuregroupTable;

    public AgentInputs() {
        this.m_featuregroupTable = new Hashtable();
    }

    public AgentInputs(AgentInputs agentInputs) {
        if (agentInputs == null) {
            throw new IllegalArgumentException("Null AgentVision given to copy constructor.");
        }
        this.m_featuregroupTable = new Hashtable<String, List<SensoryItem>>(agentInputs.m_featuregroupTable);
    }

    public Hashtable<String, List<SensoryItem>> getSensoryItems() {
        return new Hashtable<String, List<SensoryItem>>(this.m_featuregroupTable);
    }

    public void setSensoryItems(Hashtable<String, List<SensoryItem>> hashtable) {
        this.m_featuregroupTable = new Hashtable<String, List<SensoryItem>>(hashtable);
    }

    public void addSensoryItem(SensoryItem sensoryItem) {
        if (sensoryItem == null) {
            throw new IllegalArgumentException("Null SensoryItem added to AgentVision.");
        }
        if (this.m_featuregroupTable.containsKey(sensoryItem.getFeatureName())) {
            List<SensoryItem> list = this.m_featuregroupTable.get(sensoryItem.getFeatureName());
            list.add(sensoryItem);
            this.m_featuregroupTable.put(sensoryItem.getFeatureName(), list);
        } else {
            ArrayList<SensoryItem> arrayList = new ArrayList<SensoryItem>();
            arrayList.add(sensoryItem);
            this.m_featuregroupTable.put(sensoryItem.getFeatureName(), arrayList);
        }
    }

    public boolean doesContain(String string) {
        if (string == null) {
            throw new IllegalArgumentException("SensoryItem name was null.");
        }
        List<SensoryItem> list = this.m_featuregroupTable.get(string);
        return list != null && list.size() != 0;
    }

    public int getNumberSensoryItems(String string) {
        if (string == null) {
            throw new IllegalArgumentException("SensoryItem name was null.");
        }
        List<SensoryItem> list = this.m_featuregroupTable.get(string);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public int getNumberSensoryItems() {
        Collection<List<SensoryItem>> collection = this.m_featuregroupTable.values();
        int n = 0;
        for (List<SensoryItem> list : collection) {
            if (list == null) continue;
            n += list.size();
        }
        return n;
    }

    public void removeSensoryItemType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("SensoryItem name was null.");
        }
        List<SensoryItem> list = this.m_featuregroupTable.get(string);
        if (list != null) {
            list.clear();
            this.m_featuregroupTable.remove(string);
        }
    }

    public List<SensoryItem> getSensoryItems(String string) {
        if (string == null) {
            throw new IllegalArgumentException("SensoryItem name was null.");
        }
        List<SensoryItem> list = this.m_featuregroupTable.get(string);
        return list;
    }

    public List<String> getSensoryItemNames() {
        Set<String> set = this.m_featuregroupTable.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set);
        return arrayList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AgentInputs)) {
            return false;
        }
        AgentInputs agentInputs = (AgentInputs)object;
        if (this.getNumberSensoryItems() != agentInputs.getNumberSensoryItems()) {
            return false;
        }
        List<String> list = this.getSensoryItemNames();
        List<String> list2 = agentInputs.getSensoryItemNames();
        if (list.size() != list2.size()) {
            return false;
        }
        for (String string : list) {
            if (!list2.contains(string)) {
                return false;
            }
            if (this.getNumberSensoryItems(string) != agentInputs.getNumberSensoryItems(string)) {
                return false;
            }
            List<SensoryItem> list3 = this.getSensoryItems(string);
            List<SensoryItem> list4 = agentInputs.getSensoryItems(string);
            for (SensoryItem sensoryItem : list3) {
                if (list4.contains(sensoryItem)) continue;
                return false;
            }
        }
        return true;
    }

    public void Diff(AgentInputs agentInputs) {
        Object object;
        int n;
        List<SensoryItem> list;
        String string = "      ";
        if (this.getNumberSensoryItems() != agentInputs.getNumberSensoryItems()) {
            System.out.println(string + "Difference in the number of Sensory Items");
        }
        List<String> list2 = this.getSensoryItemNames();
        List<String> list3 = agentInputs.getSensoryItemNames();
        String string2 = string + "  >";
        String string3 = string + "  <";
        for (String string4 : list2) {
            System.out.println(string + string4);
            list = this.getSensoryItems(string4);
            n = 0;
            for (SensoryItem sensoryItem : list) {
                object = Integer.toString(++n);
                System.out.println(string2 + " " + (String)object + ":" + sensoryItem.getFeatureName());
            }
            n = 0;
            if (!list3.contains(string4)) continue;
            List<SensoryItem> list4 = agentInputs.getSensoryItems(string4);
            Iterator iterator = list4.iterator();
            while (iterator.hasNext()) {
                object = (SensoryItem)iterator.next();
                String string5 = Integer.toString(++n);
                System.out.println(string3 + " " + string5 + ":" + ((SensoryItem)object).getFeatureName());
            }
            list3.remove(string4);
        }
        for (String string4 : list3) {
            System.out.println(string + string4);
            list = agentInputs.getSensoryItems(string4);
            n = 0;
            for (SensoryItem sensoryItem : list) {
                object = Integer.toString(++n);
                System.out.println(string3 + " " + (String)object + ":" + sensoryItem.getFeatureName());
            }
        }
    }
}

