/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.JIFSA.AgentAction;
import org.JIFSA.AgentInputs;
import org.JIFSA.reasoning.distance.GlobalDistanceMeasure;

public class Case
implements Serializable {
    private static final long serialVersionUID = -7056509620159922081L;
    private static GlobalDistanceMeasure m_globaldistancemeasure = null;
    private AgentInputs m_inputs;
    private List<AgentAction> m_actions;

    public Case() {
        this.m_inputs = new AgentInputs();
        this.m_actions = new ArrayList<AgentAction>();
    }

    public Case(AgentInputs agentInputs, List<AgentAction> list) {
        if (agentInputs == null || list == null) {
            throw new IllegalArgumentException("Null AgentInputs or AgentActions list given when creating a Case");
        }
        this.m_inputs = agentInputs;
        this.m_actions = list;
    }

    public void setActions(List<AgentAction> list) {
        this.m_actions = new ArrayList<AgentAction>(list);
    }

    public List<AgentAction> getActions() {
        return new ArrayList<AgentAction>(this.m_actions);
    }

    public AgentInputs getInputs() {
        return this.m_inputs;
    }

    public void setInputs(AgentInputs agentInputs) {
        this.m_inputs = agentInputs;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Case)) {
            return false;
        }
        Case case_ = (Case)object;
        AgentInputs agentInputs = case_.getInputs();
        List<AgentAction> list = case_.getActions();
        if (list.size() != this.m_actions.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).equals(this.m_actions.get(i))) continue;
            return false;
        }
        return agentInputs.equals(this.m_inputs);
    }

    public static void setGlobalDistanceCalculation(GlobalDistanceMeasure globalDistanceMeasure) {
        if (globalDistanceMeasure == null) {
            throw new IllegalArgumentException("Null GlobalDistanceMeasure given to Case");
        }
        m_globaldistancemeasure = globalDistanceMeasure;
    }

    public static GlobalDistanceMeasure getGloablDistanceCalculation() {
        return m_globaldistancemeasure;
    }

    public static float pairwiseDistance(Case case_, Case case_2) {
        if (case_ == null || case_2 == null) {
            throw new IllegalArgumentException("Null Case given to pairwiseDistance method.");
        }
        if (m_globaldistancemeasure == null) {
            throw new IllegalStateException("The Case global distance algorithm has not been set.");
        }
        return m_globaldistancemeasure.pairwiseDistance(case_, case_2);
    }

    public void Diff(Case case_) {
        AgentInputs agentInputs;
        String string = "    ";
        AgentInputs agentInputs2 = this.getInputs();
        if (!agentInputs2.equals(agentInputs = case_.getInputs())) {
            System.out.println(string + "Inputs difference");
            agentInputs2.Diff(agentInputs);
        }
        List<AgentAction> list = this.getActions();
        List<AgentAction> list2 = case_.getActions();
        if (list.size() != list2.size()) {
            System.out.println(string + "Difference: in the number of actions" + Integer.toString(list.size()) + " " + Integer.toString(list2.size()));
        } else {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).equals(list2.get(i))) continue;
                System.out.println(string + "Action difference");
            }
        }
    }
}

