/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.JIFSA.Case;

public class CaseBase
implements Serializable {
    private static final long serialVersionUID = -5826431951330607037L;
    private List<Case> m_casebase;

    public CaseBase() {
        this.m_casebase = new ArrayList<Case>();
    }

    public CaseBase(CaseBase caseBase) {
        if (caseBase == null) {
            throw new IllegalArgumentException("Null paramater given to CaseBase constructor");
        }
        List<Case> list = caseBase.getCaseList();
        this.m_casebase = new ArrayList<Case>(list);
    }

    public int getCasebaseSize() {
        return this.m_casebase.size();
    }

    public void addCase(Case case_) {
        if (case_ == null) {
            throw new IllegalArgumentException("Null Case added to CaseBase.");
        }
        this.m_casebase.add(case_);
    }

    public List<Case> getCaseList() {
        return new ArrayList<Case>(this.m_casebase);
    }

    public void setCaseList(List<Case> list) {
        if (list == null) {
            throw new IllegalArgumentException("Null paramater given to CaseBase constructor");
        }
        this.m_casebase = new ArrayList<Case>(list);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CaseBase)) {
            return false;
        }
        CaseBase caseBase = (CaseBase)object;
        if (this.getCasebaseSize() != caseBase.getCasebaseSize()) {
            return false;
        }
        for (Case case_ : caseBase.getCaseList()) {
            if (this.m_casebase.contains(case_)) continue;
            return false;
        }
        return true;
    }

    public void Diff(CaseBase caseBase) {
        List<Case> list = this.getCaseList();
        List<Case> list2 = caseBase.getCaseList();
        ListIterator<Case> listIterator = list.listIterator();
        ListIterator<Case> listIterator2 = list2.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            String string = Integer.toString(++n);
            if (listIterator2.hasNext()) {
                Case case_;
                Case case_2 = listIterator.next();
                if (case_2.equals(case_ = listIterator2.next())) {
                    System.out.println("  Case " + string + " is ok.");
                    continue;
                }
                System.out.println("  Case " + string);
                case_2.Diff(case_);
                continue;
            }
            System.out.println("  The first Case Base has more cases than the second one.");
        }
        if (listIterator2.hasNext()) {
            System.out.println("  The second Case Base has more cases than the first one.");
        }
    }
}

