/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA;

import java.io.Serializable;
import org.JIFSA.reasoning.distance.DistanceCalculation;
import org.JIFSA.reasoning.distance.penalty.PenaltyDistance;

public class SensoryItem
implements Serializable {
    private static final long serialVersionUID = -6837660342788953122L;
    private static DistanceCalculation m_distanceCalculation = null;
    private static PenaltyDistance m_penaltyCalculation = null;
    private String m_featureName;

    public SensoryItem(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null name when creating a SensoryItem.");
        }
        this.m_featureName = string;
    }

    public String getFeatureName() {
        return this.m_featureName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SensoryItem)) {
            return false;
        }
        SensoryItem sensoryItem = (SensoryItem)object;
        return this.m_featureName.equals(sensoryItem.getFeatureName());
    }

    public static void setDistanceCalculation(DistanceCalculation distanceCalculation) {
        if (distanceCalculation == null) {
            throw new IllegalArgumentException("Distance calculation algorithm cannot be null.");
        }
        m_distanceCalculation = distanceCalculation;
    }

    public static void removeDistanceCalculation() {
        m_distanceCalculation = null;
    }

    public float pairwiseDistance(SensoryItem sensoryItem) {
        if (sensoryItem == null) {
            throw new IllegalArgumentException("A null feature was given.");
        }
        if (m_distanceCalculation == null) {
            throw new IllegalStateException("The distance calculation algorithm has not yet been set.");
        }
        return m_distanceCalculation.pairwiseDistance(this, sensoryItem);
    }

    public static void setPenaltyDistanceCalculation(PenaltyDistance penaltyDistance) {
        if (penaltyDistance == null) {
            throw new IllegalArgumentException("Penalty calculation algorithm cannot be null.");
        }
        m_penaltyCalculation = penaltyDistance;
    }

    public static void removePenaltyDistanceCalculation() {
        m_penaltyCalculation = null;
    }

    public float penaltyDistance() {
        if (m_penaltyCalculation == null) {
            throw new IllegalStateException("The penalty calculation algorithm has not yet been set.");
        }
        return m_penaltyCalculation.calculatePenalty(this);
    }

    public String toXML() {
        String string = "";
        string = string + "<SensoryItem>";
        string = string + "<FeatureName>";
        string = string + this.m_featureName;
        string = string + "</FeatureName>";
        string = string + "</SensoryItem>";
        return string;
    }
}

