/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA.performance;

import org.JIFSA.Agent;
import org.JIFSA.AgentAction;
import org.JIFSA.AgentInputs;
import org.JIFSA.Case;
import org.JIFSA.performance.PerformanceWrapper;

public class MeanExecutionTime
implements PerformanceWrapper {
    private Agent m_agent;
    private long m_totalTime;
    private int m_numInputs;

    public MeanExecutionTime(Agent agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Null Agent given to MeanExecutionTime.");
        }
        this.m_agent = agent;
        this.m_totalTime = 0L;
        this.m_numInputs = 0;
    }

    @Override
    public AgentAction senseEnvironment(Case case_) {
        if (case_ == null) {
            throw new IllegalArgumentException("Null Case given to senseEnvironment");
        }
        AgentInputs agentInputs = case_.getInputs();
        long l = System.currentTimeMillis();
        AgentAction agentAction = this.m_agent.senseEnvironment(agentInputs);
        long l2 = System.currentTimeMillis();
        this.m_totalTime += l2 - l;
        ++this.m_numInputs;
        return agentAction;
    }

    public float getMeanExecutionTime() {
        if (this.m_numInputs == 0) {
            return 0.0f;
        }
        return (float)this.m_totalTime / (float)this.m_numInputs;
    }
}

