/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA.performance;

public class StatisticsBundle {
    private float[] m_stats;
    private String[] m_labels;
    private int m_primary;

    public StatisticsBundle(float[] fArray, String[] stringArray) {
        if (fArray.length != stringArray.length) {
            throw new IllegalArgumentException("Number of statistics different from number of labels");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("At least one statistic is required for a StatisticsBundle");
        }
        this.m_primary = 0;
        this.m_stats = fArray;
        this.m_labels = stringArray;
    }

    public float getPrimaryStatistic() {
        return this.m_stats[this.m_primary];
    }

    public String getPrimaryLabel() {
        return this.m_labels[this.m_primary];
    }

    public float[] getAllStatistics() {
        return this.m_stats;
    }

    public String[] getLabels() {
        return this.m_labels;
    }

    public void setPrimaryStatistic(int n) {
        if (n > this.m_stats.length - 1) {
            throw new IllegalArgumentException("Invalid statistic index given - too high.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid statistic index given - too low.");
        }
        this.m_primary = n;
    }
}

