/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA.performance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.JIFSA.Agent;
import org.JIFSA.AgentAction;
import org.JIFSA.Case;
import org.JIFSA.performance.PerformanceWrapper;
import org.JIFSA.performance.StatisticsBundle;
import org.JIFSA.reasoning.actionselection.actionestimation.ActionEstimation;

public abstract class StatisticsWrapper
implements PerformanceWrapper {
    public static final String NOACTION = "NO_ACTION";
    protected PerformanceWrapper m_internalWrapper;
    protected Agent m_agent;
    protected ActionEstimation m_actionEstimation;
    protected Map<String, Map<String, Integer>> m_confusion;

    public StatisticsWrapper(PerformanceWrapper performanceWrapper, ActionEstimation actionEstimation) {
        if (actionEstimation == null) {
            throw new IllegalArgumentException("Null ActionEstimation given to StatisticsWrapper");
        }
        if (performanceWrapper == null) {
            throw new IllegalArgumentException("Null PerformanceWrapper given to StatisticsWrapper");
        }
        this.m_internalWrapper = performanceWrapper;
        this.m_agent = null;
        this.m_actionEstimation = actionEstimation;
        this.m_confusion = new HashMap<String, Map<String, Integer>>();
    }

    public StatisticsWrapper(Agent agent, ActionEstimation actionEstimation) {
        if (actionEstimation == null) {
            throw new IllegalArgumentException("Null ActionEstimation given to StatisticsWrapper");
        }
        if (agent == null) {
            throw new IllegalArgumentException("Null Agent given to StatisticsWrapper");
        }
        this.m_internalWrapper = null;
        this.m_agent = agent;
        this.m_actionEstimation = actionEstimation;
        this.m_confusion = new HashMap<String, Map<String, Integer>>();
    }

    @Override
    public AgentAction senseEnvironment(Case case_) {
        if (case_ == null) {
            throw new IllegalArgumentException("Null case given to StatisticsWrapper");
        }
        List<AgentAction> list = case_.getActions();
        AgentAction agentAction = this.m_actionEstimation.estimateAction(list);
        if (this.m_internalWrapper != null) {
            AgentAction agentAction2 = this.m_internalWrapper.senseEnvironment(case_);
            this.actionPair(agentAction, agentAction2);
            return agentAction2;
        }
        if (this.m_agent != null) {
            AgentAction agentAction3 = this.m_agent.senseEnvironment(case_.getInputs());
            this.actionPair(agentAction, agentAction3);
            return agentAction3;
        }
        throw new IllegalStateException("Neither a PerformanceWrapper nor Agent was set.");
    }

    public float getClassificationAccuracy() {
        int n = 0;
        int n2 = 0;
        Set<String> set = this.m_confusion.keySet();
        for (String string : set) {
            Map<String, Integer> map = this.m_confusion.get(string);
            Set<String> set2 = map.keySet();
            for (String string2 : set2) {
                Integer n3 = map.get(string2);
                if (string.equals(string2)) {
                    n += n3.intValue();
                }
                n2 += n3.intValue();
            }
        }
        if (n2 == 0) {
            return 0.0f;
        }
        return (float)n / (float)n2;
    }

    public float getPrecision(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null String given to getPrecision()");
        }
        int n = 0;
        int n2 = 0;
        Set<String> set = this.m_confusion.keySet();
        for (String string2 : set) {
            Map<String, Integer> map = this.m_confusion.get(string2);
            Integer n3 = map.get(string);
            if (n3 == null) continue;
            if (string2.equals(string)) {
                n += n3.intValue();
            }
            n2 += n3.intValue();
        }
        if (n2 == 0) {
            return 0.0f;
        }
        return (float)n / (float)n2;
    }

    public float getRecall(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null String given to getRecall()");
        }
        Map<String, Integer> map = this.m_confusion.get(string);
        if (map == null) {
            return 0.0f;
        }
        int n = 0;
        int n2 = 0;
        Set<String> set = map.keySet();
        for (String string2 : set) {
            Integer n3 = map.get(string2);
            if (string.equals(string2)) {
                n += n3.intValue();
            }
            n2 += n3.intValue();
        }
        return (float)n / (float)n2;
    }

    public float getF1(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null value given to getF1");
        }
        float f = this.getPrecision(string);
        float f2 = this.getRecall(string);
        float f3 = 2.0f * f * f2;
        float f4 = f + f2;
        if (f4 == 0.0f) {
            return 0.0f;
        }
        return f3 / f4;
    }

    public float getGlobalF1() {
        int n = 0;
        float f = 0.0f;
        Set<String> set = this.m_confusion.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set);
        for (String string : set) {
            Map<String, Integer> map = this.m_confusion.get(string);
            Set<String> set2 = map.keySet();
            for (String string2 : set2) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        for (String string : arrayList) {
            f += this.getF1(string);
            ++n;
        }
        if (n == 0) {
            return 0.0f;
        }
        return f / (float)n;
    }

    public List<String> getAllExpectedActions() {
        return new ArrayList<String>(this.m_confusion.keySet());
    }

    public StatisticsBundle getStatisticsBundle() {
        List<String> list = this.getAllExpectedActions();
        int n = 2 + list.size() * 3;
        float[] fArray = new float[n];
        String[] stringArray = new String[n];
        fArray[0] = this.getGlobalF1();
        stringArray[0] = "Global F1";
        fArray[1] = this.getClassificationAccuracy();
        stringArray[1] = "Classification Accuracy";
        int n2 = 2;
        for (String string : list) {
            fArray[n2] = this.getF1(string);
            stringArray[n2] = "F1 " + string;
            fArray[++n2] = this.getPrecision(string);
            stringArray[n2] = "Precision " + string;
            fArray[++n2] = this.getRecall(string);
            stringArray[n2] = "Recall " + string;
            ++n2;
        }
        StatisticsBundle statisticsBundle = new StatisticsBundle(fArray, stringArray);
        return statisticsBundle;
    }

    protected abstract void actionPair(AgentAction var1, AgentAction var2);

    protected void addPair(String string, String string2) {
        Integer n;
        Map<String, Integer> map = this.m_confusion.get(string);
        if (map == null) {
            map = new HashMap<String, Integer>();
        }
        n = (n = map.get(string2)) == null ? new Integer(1) : new Integer(n + 1);
        map.put(string2, n);
        this.m_confusion.put(string, map);
    }
}

