/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA.preprocessing.featureselection;

import java.util.List;
import org.JIFSA.Agent;
import org.JIFSA.Case;
import org.JIFSA.CaseBase;
import org.JIFSA.performance.ClassificationStatisticsWrapper;
import org.JIFSA.performance.StatisticsBundle;
import org.JIFSA.preprocessing.featureselection.FeatureWeightEvaluation;
import org.JIFSA.reasoning.Weights;
import org.JIFSA.reasoning.actionselection.actionestimation.ActionEstimation;
import org.JIFSA.tools.RandomCaseBase;

public class StandardEvaluation
implements FeatureWeightEvaluation {
    private Agent m_evaluationAgent;
    private CaseBase m_training;
    private CaseBase m_testing;
    private ActionEstimation m_ae;

    public StandardEvaluation(Agent agent, ActionEstimation actionEstimation, CaseBase caseBase, int n, int n2) {
        if (agent == null) {
            throw new IllegalArgumentException("Null agent.");
        }
        if (actionEstimation == null) {
            throw new IllegalArgumentException("Null ActionEstimation.");
        }
        if (caseBase == null) {
            throw new IllegalArgumentException("Null CaseBase.");
        }
        if (n <= 0 || n > caseBase.getCasebaseSize()) {
            throw new IllegalArgumentException("Invalid number of training Cases specified.");
        }
        if (n2 <= 0 || n2 > caseBase.getCasebaseSize()) {
            throw new IllegalArgumentException("Invalid number of training Cases specified.");
        }
        this.m_evaluationAgent = agent;
        this.m_ae = actionEstimation;
        this.m_training = RandomCaseBase.random(caseBase, n);
        this.m_evaluationAgent.setCaseBase(this.m_training);
        this.m_testing = RandomCaseBase.random(caseBase, n2);
    }

    @Override
    public StatisticsBundle evaluate(Weights weights) {
        if (weights == null) {
            throw new IllegalArgumentException("Null object weights.");
        }
        Case.getGloablDistanceCalculation().setWeights(weights);
        List<Case> list = this.m_testing.getCaseList();
        ClassificationStatisticsWrapper classificationStatisticsWrapper = new ClassificationStatisticsWrapper(this.m_evaluationAgent, this.m_ae);
        for (Case case_ : list) {
            classificationStatisticsWrapper.senseEnvironment(case_);
        }
        return classificationStatisticsWrapper.getStatisticsBundle();
    }
}

