/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA.preprocessing.featureselection.algorithms;

import java.util.ArrayList;
import java.util.List;
import org.JIFSA.performance.StatisticsBundle;
import org.JIFSA.preprocessing.featureselection.FeatureWeightEvaluation;
import org.JIFSA.preprocessing.featureselection.algorithms.WrapperFSA;
import org.JIFSA.reasoning.Weights;

public class SequentialBackwardGeneration
implements WrapperFSA {
    private Weights m_best;
    private float m_evalBest;
    private StatisticsBundle m_statsBest;
    private List<Weights> m_closed;
    private List<Weights> m_open;
    private List<Float> m_evalOpen;
    private List<StatisticsBundle> m_statsOpen;
    private int m_k;
    private double m_multiplier;
    private FeatureWeightEvaluation m_fwe;

    public SequentialBackwardGeneration(int n, double d) {
        if (n < 1) {
            throw new IllegalArgumentException("k-value must be greater than zero.");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("epsilon must be positive.");
        }
        this.m_k = n;
        this.m_multiplier = 1.0 + d / 100.0;
        this.m_best = null;
        this.m_evalBest = -1.0f;
        this.m_statsBest = null;
        this.m_closed = new ArrayList<Weights>();
        this.m_open = new ArrayList<Weights>();
        this.m_evalOpen = new ArrayList<Float>();
        this.m_statsOpen = new ArrayList<StatisticsBundle>();
        this.m_fwe = null;
    }

    @Override
    public Weights selectFeatures(FeatureWeightEvaluation featureWeightEvaluation, Weights weights) {
        if (featureWeightEvaluation == null) {
            throw new IllegalArgumentException("Null FeatureWeightEvaluation given.");
        }
        this.m_fwe = featureWeightEvaluation;
        this.m_statsBest = this.m_fwe.evaluate(weights);
        this.m_evalBest = this.m_statsBest.getPrimaryStatistic();
        this.m_best = weights;
        Weights weights2 = weights;
        int n = 0;
        while (n < this.m_k) {
            this.m_closed.add(weights2);
            this.determineChildren(weights2);
            if (this.m_open.size() == 0) break;
            weights2 = this.m_open.remove(0);
            float f = this.m_evalOpen.remove(0).floatValue();
            StatisticsBundle statisticsBundle = this.m_statsOpen.remove(0);
            if ((double)f > (double)this.m_evalBest * this.m_multiplier) {
                this.m_best = weights2;
                this.m_statsBest = statisticsBundle;
                this.m_evalBest = f;
                n = 0;
                continue;
            }
            ++n;
        }
        return this.m_best;
    }

    private void determineChildren(Weights weights) {
        List<String> list = weights.getWeightedItemNames();
        for (String string : list) {
            if (!(weights.getWeight(string) > 0.0f)) continue;
            Weights weights2 = new Weights(0.0f);
            for (String string2 : list) {
                weights2.setWeight(string2, weights.getWeight(string2));
            }
            weights2.setWeight(string, 0.0f);
            if (this.m_closed.contains(weights2) || this.m_open.contains(weights2)) continue;
            System.out.println("Evaluating new child: " + weights2);
            StatisticsBundle statisticsBundle = this.m_fwe.evaluate(weights2);
            float f = statisticsBundle.getPrimaryStatistic();
            this.placeInList(weights2, f, statisticsBundle);
        }
    }

    private void placeInList(Weights weights, float f, StatisticsBundle statisticsBundle) {
        boolean bl = false;
        for (int i = 0; i < this.m_evalOpen.size(); ++i) {
            if (!(f > this.m_evalOpen.get(i).floatValue())) continue;
            this.m_evalOpen.add(i, new Float(f));
            this.m_statsOpen.add(i, statisticsBundle);
            this.m_open.add(i, weights);
            bl = true;
            break;
        }
        if (!bl) {
            this.m_evalOpen.add(new Float(f));
            this.m_statsOpen.add(statisticsBundle);
            this.m_open.add(weights);
        }
    }

    @Override
    public StatisticsBundle getStatisticsOfBestWeights() {
        return this.m_statsBest;
    }
}

