/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA.reasoning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Weights {
    private float m_defaultWeight;
    private Map<String, Float> m_weights;

    public Weights(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("The weights must be between 0.0 and 1.0 (inclusive)");
        }
        this.m_defaultWeight = f;
        this.m_weights = new HashMap<String, Float>();
    }

    public void setWeight(String string, float f) {
        if (string == null) {
            throw new IllegalArgumentException("Null parameter given to Weights object.");
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("The weights must be between 0.0 and 1.0 (inclusive)");
        }
        this.m_weights.put(string, new Float(f));
    }

    public List<String> getWeightedItemNames() {
        Set<String> set = this.m_weights.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set);
        return arrayList;
    }

    public float getWeight(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null parameter given to Weights object.");
        }
        Float f = this.m_weights.get(string);
        if (f == null) {
            return this.m_defaultWeight;
        }
        return f.floatValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Weights)) {
            return false;
        }
        Weights weights = (Weights)object;
        if (this.m_defaultWeight != weights.m_defaultWeight) {
            return false;
        }
        return ((Object)this.m_weights).equals(weights.m_weights);
    }

    public String toString() {
        String string = "{";
        List<String> list = this.getWeightedItemNames();
        for (String string2 : list) {
            if (list.indexOf(string2) != 0) {
                string = string + ",";
            }
            string = string + string2 + ":" + this.getWeight(string2);
        }
        string = string + "}";
        return string;
    }
}

