/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA.reasoning.casebasesearch;

import java.util.ArrayList;
import java.util.List;
import org.JIFSA.Case;
import org.JIFSA.CaseBase;
import org.JIFSA.reasoning.casebasesearch.CaseBaseSearch;

public class NearestNeighbourSearch
implements CaseBaseSearch {
    private int m_numNeighbours;

    public NearestNeighbourSearch(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid number of neighbours given to NearestNeighbourSearch");
        }
        this.m_numNeighbours = n;
    }

    @Override
    public List<Case> findClosest(Case case_, CaseBase caseBase) {
        if (case_ == null) {
            throw new IllegalArgumentException("Null Case given to NearestNeighbourSearch");
        }
        if (caseBase == null) {
            throw new IllegalArgumentException("Null CaseBase given to NearestNeighbourSearch");
        }
        ArrayList<Case> arrayList = new ArrayList<Case>(this.m_numNeighbours);
        ArrayList<Float> arrayList2 = new ArrayList<Float>(this.m_numNeighbours);
        for (int i = 0; i < this.m_numNeighbours; ++i) {
            arrayList.add(null);
            arrayList2.add(new Float(Float.MAX_VALUE));
        }
        List<Case> list = caseBase.getCaseList();
        block1: for (Case case_2 : list) {
            float f = Case.pairwiseDistance(case_, case_2);
            for (int i = 0; i < this.m_numNeighbours; ++i) {
                if (!(f < ((Float)arrayList2.get(i)).floatValue())) continue;
                arrayList.add(i, case_2);
                arrayList2.add(i, new Float(f));
                arrayList.remove(this.m_numNeighbours);
                arrayList2.remove(this.m_numNeighbours);
                continue block1;
            }
        }
        while (arrayList.remove(null)) {
        }
        return arrayList;
    }
}

