/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA.reasoning.distance;

import java.util.ArrayList;
import java.util.Map;
import org.JIFSA.Case;
import org.JIFSA.reasoning.Weights;

public abstract class GlobalDistanceMeasure {
    protected Weights m_featureWeights;

    public GlobalDistanceMeasure(Weights weights) {
        if (weights == null) {
            throw new IllegalArgumentException("Null Weights given to GlobalDistanceMeasure");
        }
        this.m_featureWeights = weights;
    }

    public abstract float pairwiseDistance(Case var1, Case var2);

    public void setWeights(Weights weights) {
        if (weights == null) {
            throw new IllegalArgumentException("Null weights given to GlobalDistanceMeasure");
        }
        this.m_featureWeights = weights;
    }

    public Weights getWeights() {
        return this.m_featureWeights;
    }

    protected float weightedDistance(Map<String, Float> map) {
        float f = 0.0f;
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        for (String string : arrayList) {
            float f2 = map.get(string).floatValue();
            float f3 = this.m_featureWeights.getWeight(string);
            f += f2 * f3;
        }
        return f;
    }
}

