/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA.reasoning.distance.spatial2D;

import org.JIFSA.SensoryItem;
import org.JIFSA.reasoning.distance.DistanceCalculation;
import org.JIFSA.sensoryItems.Spatial2DObject;

public class PolarDistanceAlgorithm
implements DistanceCalculation {
    @Override
    public float pairwiseDistance(SensoryItem sensoryItem, SensoryItem sensoryItem2) {
        if (sensoryItem == null || sensoryItem2 == null) {
            throw new IllegalArgumentException("Null first feature given to polar distance algorithm.");
        }
        if (!(sensoryItem instanceof Spatial2DObject) || !(sensoryItem2 instanceof Spatial2DObject)) {
            throw new IllegalArgumentException("Non-spatial features given to polar distance algorithm.");
        }
        Spatial2DObject spatial2DObject = (Spatial2DObject)sensoryItem;
        Spatial2DObject spatial2DObject2 = (Spatial2DObject)sensoryItem2;
        float f = spatial2DObject.getDistance();
        float f2 = spatial2DObject.getDirection();
        float f3 = spatial2DObject2.getDistance();
        float f4 = spatial2DObject2.getDirection();
        double d = Math.abs(f4 - f2);
        double d2 = Math.toRadians(d);
        double d3 = (double)(2.0f * f * f3) * Math.cos(d2);
        double d4 = (double)(f * f + f3 * f3) - d3;
        return (float)Math.sqrt(d4);
    }
}

