/*
 * Decompiled with CFR 0.152.
 */
package org.JIFSA.sensoryItems;

import org.JIFSA.SensoryItem;
import org.JIFSA.reasoning.distance.DistanceCalculation;

public class Spatial2DObject
extends SensoryItem {
    private static final long serialVersionUID = 2126001314974619011L;
    private static DistanceCalculation m_distanceCalculation = null;
    private float m_distance = 0.0f;
    private float m_direction = 0.0f;

    public Spatial2DObject(String string) {
        super(string);
    }

    public void setDistance(float f) {
        this.m_distance = f;
    }

    public void setDirection(float f) {
        this.m_direction = f;
    }

    public float getDistance() {
        return this.m_distance;
    }

    public float getDirection() {
        return this.m_direction;
    }

    public static void setDistanceCalculation(DistanceCalculation distanceCalculation) {
        if (distanceCalculation == null) {
            throw new IllegalArgumentException("Null DistanceCalculation given to Spatial2DObject");
        }
        m_distanceCalculation = distanceCalculation;
    }

    public static void removeDistanceCalculation() {
        m_distanceCalculation = null;
    }

    @Override
    public float pairwiseDistance(SensoryItem sensoryItem) {
        if (sensoryItem == null) {
            throw new IllegalArgumentException("Null Spatial2DFeatures given to pairwiseDistance method");
        }
        if (!(sensoryItem instanceof Spatial2DObject)) {
            throw new IllegalArgumentException("Features given to pairwiseDistance method must be Spatial2DObjects");
        }
        if (m_distanceCalculation == null) {
            return super.pairwiseDistance(sensoryItem);
        }
        return m_distanceCalculation.pairwiseDistance(this, sensoryItem);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Spatial2DObject)) {
            return false;
        }
        Spatial2DObject spatial2DObject = (Spatial2DObject)object;
        if (!super.equals(spatial2DObject)) {
            return false;
        }
        return this.m_direction == spatial2DObject.getDirection() && this.m_distance == spatial2DObject.getDistance();
    }
}

