/** AgentAction.java in the package org.JIFSA of the JIFSA project.
    Originally created 17-Jun-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package org.JIFSA;

import java.io.Serializable;

/** An action performed by an agent
 * 
 * @author Michael W. Floyd
 * @since 0.1
 */
public class AgentAction implements Serializable {

	private static final long serialVersionUID = -5016928749312458311L;

	/** The name of the default action */
	public static String c_DEFAULT = "default";
	
	/** The name of this action */
	private String m_name;
	
	/** Default constructor for an AgentAction object
	  * 
	  * @author Michael W. Floyd
	  * @since 0.1
	  */
	public AgentAction() {
		this.m_name = AgentAction.c_DEFAULT;
	}
	
	/** Constructor for an AgentAction object given the name of the action
	  * 
	  * @param actionName The name of the action
	  * 
	  * @author Michael W. Floyd
	  * @since 0.1
	  */
	public AgentAction(String actionName) {
		//check params
		if(actionName == null){
			throw new IllegalArgumentException("Null action name given to constructor.");
		}
		
		this.m_name = actionName;
	}
	
	/** Returns the name of the action
	 * 
	 * @return The name of the actions
	 *
	 * @author Michael W. Floyd
	 * @since 0.1 
	 */
	public String getActionName(){
		return this.m_name;
	}
	
	/** Overrides the equals method
	 * 
	 */
	@Override
	public boolean equals(Object o){
		//see if this is the object
		if(this == o){
			return true;
		}
		
		//test for null or other class type
		if(o == null || !(o instanceof AgentAction)){
			return false;
		}
		
		//typecast the object
		AgentAction aa = (AgentAction)o;
		
		//we compare action names
		return this.m_name.equals(aa.getActionName());
	}
}
