/** Cluster.java in the package org.JIFSA.preprocessing.cluster of the JIFSA project.
    Originally created 07-Feb-08

    Copyright (C) 2008  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package org.JIFSA.preprocessing.cluster;

import java.util.ArrayList;
import java.util.List;

import org.JIFSA.Case;

/** This class is used to store a grouping of Cases, called a Cluster.
 * 
 * @author Michael W. Floyd
 * @since 0.5
 */
public class Cluster {

	//used to store the members of the cluster
	private List<Case> m_members;
	
	/** Creates an empty Cluster that contains no Cases
	 * 
	 * @author Michael W. Floyd
	 * @since 0.5
	 */
	public Cluster(){
		this.m_members = new ArrayList<Case>();
	}
	
	/** Retrieves all of the Cases that are in the Cluster.
	 * 
	 * @return the Cases that are part of the Cluster
	 * 
	 * @author Michael W. Floyd
	 * @since 0.5
	 */
	public List<Case> getMembers() {
		return this.m_members;
	}

	/** Adds a Case to the Cluster
	 * 
	 * @param c The Case to add to the Cluster
	 * 
	 * @author Michael W. Floyd
	 * @since 0.5
	 */
	public void addMember(Case c) {
		if(c == null){
			throw new IllegalArgumentException("Null Case given to Cluster.addMember(Case c)");
		}
		this.m_members.add(c);
	}

}
