/** FeatureWeightEvaluation.java in the package org.JIFSA.preprocessing.featureselection of the JIFSA project.
    Originally created 16-Feb-08

    Copyright (C) 2008  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package org.JIFSA.preprocessing.featureselection;

import org.JIFSA.reasoning.Weights;
import org.JIFSA.performance.StatisticsBundle;

/** Interface for classes that take a set of feature weights and use
 * those weights in an induction algorithm. The classes should return
 * an evaluation of how well those weights worked in the algorithm. Classes
 * that implement this interface will typically be used by wrapper feature
 * selection algorithms as a buffer between the FS algorithm and the induction
 * algorithm (the agent).
 * 
 * @author Michael W. Floyd
 * @since 0.5
 */
public interface FeatureWeightEvaluation {

	public StatisticsBundle evaluate(Weights ow);
	
}
