/** WrapperFSA.java in the package org.JIFSA.preprocessing.featureselection.algorithms of the JIFSA project.
    Originally created 16-Feb-08

    Copyright (C) 2008  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package org.JIFSA.preprocessing.featureselection.algorithms;

import org.JIFSA.performance.StatisticsBundle;
import org.JIFSA.preprocessing.featureselection.FeatureWeightEvaluation;
import org.JIFSA.reasoning.Weights;

/** Interface for wrapper feature selection algorithms.
 * 
 * @author Michael W. Floyd
 * @since 0.5
 */
public interface WrapperFSA {

	public Weights selectFeatures(FeatureWeightEvaluation fwe, Weights weights);
	
	public StatisticsBundle getStatisticsOfBestWeights();
	
}
