/** CaseFilter.java in the package org.JIFSA.preprocessing.filters of the JIFSA project.
    Originally created 25-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package org.JIFSA.preprocessing.filters;

import org.JIFSA.Case;

/** Applies a filter to a Case and modifies it in some way.
 * 
 * @author Michael W. Floyd
 * @since 0.3
 */
public interface CaseFilter {

	/** Modifies the Case using the filter.
	 * 
	 * @param initialCase The Case
	 * @return The Case after the filtering
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	public Case filter(Case initialCase);
}
