/** FeatureDistancesPresort.java in the package org.JIFSA.preprocessing.filters.casebasefilter of the JIFSA project.
    Originally created 25-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package org.JIFSA.preprocessing.filters.casebasefilter;

import java.util.List;

import org.JIFSA.Case;
import org.JIFSA.CaseBase;
import org.JIFSA.preprocessing.filters.CaseBaseFilter;
import org.JIFSA.preprocessing.filters.casefilter.FeatureDistanceCasePresort;

/** Changes the CaseBase so that all of the features are sorted by their distance
 * from the player (with the closest objects appearing first). This class is intended
 * for use with the OrderIndexMatchingAlgorithm so that the algorithm will have a
 * sorted set of features to work with. 
 * 
 * Note: Only Spatial2DObjects will be sorted, all others will remain unchanged.
 * 
 * @author Michael W. Floyd
 * @since 0.3
 */
public class FeatureDistancePresort implements CaseBaseFilter {

	/** Performs the sorting.
	 * 
	 * @param initialCB The initial case base
	 * @return The case base with sorted Spatial2DFeatures
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	public CaseBase filter(CaseBase initialCB) {
		//check parameters
		if(initialCB == null){
			throw new IllegalArgumentException("Null case base given to FeatureDistancePresort.");
		}
		
		//Create the Case filter
		FeatureDistanceCasePresort fdcp = new FeatureDistanceCasePresort();
		
		//create the new CaseBase
		CaseBase sorted = new CaseBase();
		
		//go through each Case in the CaseBase
		List<Case> allCases = initialCB.getCaseList();
		for(Case currentCase : allCases){
			Case filteredCase = fdcp.filter(currentCase);
			sorted.addCase(filteredCase);
		}
		
		return sorted;
	}

}
