/** NoActionsFilter.java in the package org.jCIFSAA.JIFSA.filters.casebasefilters of the JIFSA project.
    Originally created 25-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package org.JIFSA.preprocessing.filters.casebasefilter;

import java.util.List;

import org.JIFSA.Case;
import org.JIFSA.CaseBase;
import org.JIFSA.preprocessing.filters.CaseBaseFilter;

/** Filters a CaseBase, removing any Cases that do not have
 * any AgentActions associated with them.
 * 
 * @author Michael W. Floyd
 * @since 0.3
 */
public class NoActionsFilter implements CaseBaseFilter {

	/** Goes through the entire supplied CaseBase and removes
	 * any Cases that do not have an associated AgentAction.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	public CaseBase filter(CaseBase initialCB) {
		//check parameters
		if(initialCB == null){
			throw new IllegalArgumentException("Null CaseBase given to NoActionsFilter.");
		}
		
		CaseBase newCB = new CaseBase();
		
		//go through each Case in the initial CaseBase
		List<Case> allCases = initialCB.getCaseList();
		for(Case currentCase : allCases){
			//only add ones that have AgentActions
			if(currentCase.getActions().size() != 0){
				newCB.addCase(currentCase);
			}
		}
		
		return newCB;
	}

}
