/** ClosestNeighbourSelection.java in the package org.JIFSA.reasoning.actionselection of the JIFSA project.
    Originally created 23-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package org.JIFSA.reasoning.actionselection;

import java.util.List;

import org.JIFSA.AgentAction;
import org.JIFSA.Case;
import org.JIFSA.reasoning.actionselection.ActionSelection;
import org.JIFSA.reasoning.actionselection.actionestimation.ActionEstimation;

/** Selects the action of the closest of the most similar Case.
 * 
 * @author Michael W. Floyd
 * @since 0.3
 */
public class ClosestNeighbourSelection implements ActionSelection {

	//used to "guess" what action the agent tried to perform
	private ActionEstimation m_actionEst;
	
	/** Creates the class with the given ActionEstimation used
	 * to estimate which action the agent actually wanted to
	 * perform.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	public ClosestNeighbourSelection(ActionEstimation ae){
		if(ae == null){
			throw new IllegalArgumentException("Null value given to ClosestNeighbourSelection");
		}
		this.m_actionEst = ae;
	}
	
	/** Returns the AgentAction associated with the most similar Case.
	 * If the most similar Case has no associated action, null is returned.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	public AgentAction selectAction(List<Case> nearestNeighbours) {
		//check parameters
		if(nearestNeighbours == null){
			throw new IllegalArgumentException("Null value given to ClosestNeighbourSelection");
		}
		if(nearestNeighbours.size() == 0){
			throw new IllegalArgumentException("ClosestNeighbourSelection requires at least 1 Case to be given.");
		}
		
		//get the first Case and its actions
		Case firstCase = nearestNeighbours.get(0);
		List<AgentAction> actions = firstCase.getActions();
		
		return this.m_actionEst.estimateAction(actions);
	}

}
