/** CaseBaseSearch.java in the package org.JIFSA.reasoning.casebasesearch of the JIFSA project.
    Originally created Nov 23, 2007

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package org.JIFSA.reasoning.casebasesearch;

import java.util.List;

import org.JIFSA.Case;
import org.JIFSA.CaseBase;

/** Used to find the Cases that are closest to a specified Case.
 * 
 * @author Michael W. Floyd
 * @since 0.3
 */
public interface CaseBaseSearch {

	/** Finds the Cases in the CaseBase that are
	 * closest to the Case currentCase.
	 * 
	 * @param currentCase The Case we want to find other Cases close to
	 * @param possibleCases The other Cases we will test for closeness
	 * @return A list of the closest Cases
	 *
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	public List<Case> findClosest(Case currentCase, CaseBase possibleCases); 
}
