/** DistanceCalculation.java in the package org.JIFSA.reasoning.distance of the JIFSA project.
    Originally created 16-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package org.JIFSA.reasoning.distance;

import org.JIFSA.SensoryItem;

/** Calculates the distances between pairs of Features.
 * 
 * @author Michael W. Floyd
 * @since 0.3
 */
public interface DistanceCalculation {

	/** Calculates the distance between a pair of Features.
	 * 
	 * @param f1 The first SensoryItem
	 * @param f2 The second Feaure
	 * @return The distance between them
	 *
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	public float pairwiseDistance(SensoryItem f1, SensoryItem f2);
}
