/** EqualityDistanceAlgorithm.java in the package org.JIFSA.reasoning.distance of the JIFSA project.
    Originally created 11-Nar-08

    Copyright (C) 2007 - 2008  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */
package org.JIFSA.reasoning.distance;

import org.JIFSA.SensoryItem;

/** A simple distance calculation that returns MINDISTANCE if two features
 * are equal, and MAXDISTANCE otherwise.
 * 
 * @author Michael W. Floyd
 * @since 0.3
 *
 */
public class EqualityDistanceAlgorithm implements DistanceCalculation {

	//the minimum and maximum distance values
	public static final float MINDISTANCE = 0.0f;
	public static final float MAXDISTANCE = 1.0f;
	
	
	public float pairwiseDistance(SensoryItem f1, SensoryItem f2) {
		//check the parameters
		if(f1 == null || f2 == null){
			throw new IllegalArgumentException("Null feature given to distance calculation algorithm.");
		}
		
		//if they are equal return the min, otherwise the max
		if(f1.equals(f2)){
			return EqualityDistanceAlgorithm.MINDISTANCE;
		}
		return EqualityDistanceAlgorithm.MAXDISTANCE;
	}

}
