/** ConstantPenalty.java in the package org.JIFSA.reasoning.distance.penalty of the JIFSA project.
    Originally created 16-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package org.JIFSA.reasoning.distance.penalty;

import org.JIFSA.SensoryItem;

/** Returns a constant value for the penalty.
 * 
 * @author Michael W. Floyd
 * @since 0.3
 */
public class ConstantPenalty implements PenaltyDistance{

	//the penalty value
	private float m_penalty;
	
	/** Creates a ConstantPenalty object that always
	 * returns the penalty value that is given as
	 * a parameter to the constructor.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	public ConstantPenalty(float penalty){
		this.m_penalty = penalty;
	}
	
	/** Returns the penalty value specified in the constructor.
	 * 
	 * @author Michael W. Floyd
	 * @since 0.3
	 * 
	 */
	public float calculatePenalty(SensoryItem feat) {
		//sanity check, even though we don't use it, we still don't want null
		if(feat == null){
			throw new IllegalArgumentException("Null feature given to penalty function.");
		}
		
		return this.m_penalty;
	}

}
