/** PenaltyDistance.java in the package org.JIFSA.reasoning.distance.penalty of the JIFSA project.
    Originally created 16-Nov-07

    Copyright (C) 2007  Michael W. Floyd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 * 
 */

package org.JIFSA.reasoning.distance.penalty;

import org.JIFSA.SensoryItem;

/** Provides a penalty for Features that do not have a match, since distance
 * cannot be calculated because there is only one SensoryItem.
 * 
 * @author Michael W. Floyd
 * @since 0.3
 */
public interface PenaltyDistance {

	/** Calculates the penalty that should be assigned to
	 * the given SensoryItem which was not found to have a match.
	 * 
	 * @param feat The SensoryItem
	 * @return The amount of the penalty
	 *
	 * @author Michael W. Floyd
	 * @since 0.3
	 */
	public float calculatePenalty(SensoryItem feat);
}
